% Generated by roxygen2 (4.0.0): do not edit by hand
\name{predictResponseFromWeightedAverage}
\alias{predictResponseFromWeightedAverage}
\title{Predict a numeric response using (un)weighted averaging.}
\usage{
predictResponseFromWeightedAverage(preds, weights, .parallel, ...)
}
\arguments{
\item{preds}{is matrix of predicted classes}

\item{weights}{is a vector of length equal to \code{nrow(preds)}}

\item{.parallel}{is a boolean flag determining whether to work
across columns of \code{preds} in parallel -- need to register a
parallel backend (e.g. \code{doParallel}, \code{doRedis}) for this to
actually work.}

\item{...}{additional arguments to pass to \code{\link{weighted.mean}}.}
}
\value{
a vector of length equal to \code{ncol(preds)} containing the
estimated response for each column of \code{preds}.
}
\description{
Process a matrix of predicted responses and form a column-wise
estimate based on (un)weighted averaging.
}
\details{
Gives the prediction from row(i) in \code{preds} weight equal to
\code{weights[i]}. Note that \code{NA}'s are not removed. To have
\code{\link{weighted.mean}} remove the \code{NA}'s pass \code{na.rm=TRUE} to
the function call.
}

