% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_net.R
\name{elastic_net}
\alias{elastic_net}
\title{Elastic Net Penalization Model Estimation}
\usage{
elastic_net(
  resp,
  trt,
  subgr,
  covars,
  data,
  resptype = c("survival", "binary"),
  alpha,
  status = NULL
)
}
\arguments{
\item{resp}{(\code{string})\cr the response variable name.}

\item{trt}{(\code{string})\cr the treatment variable name. The treatment variable
must be a factor with 2 levels where the first level is the control and the
second one the treatment.}

\item{subgr}{(\code{character})\cr vector with the name of the subgroup variables
from which we want to obtain the subgroup treatment effect. They have to be
\code{factor} variables with the subgroups as levels.}

\item{covars}{(\code{character})\cr vector with the name of the variables that
we want to include in the model. They have to be \code{factor} variables with the
subgroups as levels. The \code{subgr} variables have to be included here.}

\item{data}{(\verb{data frame})\cr the data frame with the variables.}

\item{resptype}{(\code{string})\cr the type of data used. Can be "survival"
or "binary".}

\item{alpha}{(\code{scalar})\cr the elastic net mixing parameter with values
between 0 and 1. The special case of \code{alpha}=1 corresponds to a lasso
penalty and the case of \code{alpha}=0 to a ridge penalty.}

\item{status}{(\code{string})\cr only for "survival" \code{resptype},
the status variable name in survival data.}
}
\value{
List with \code{fit}, \code{model}, \code{resptype}, \code{data}, \code{alpha},
\code{design_matrix}, \code{design_dummy}, \code{y}, \code{subgr_names}.
}
\description{
Function to fit the elastic net penalization model to the data. This model
penalizes the interaction between the covariates and the treatment but
leaves unpenalized the main effects.
}
\examples{
elastic_net(
  "tt_pfs", "arm", c("x_1", "x_2"), c("x_1", "x_2", "x_3"),
  example_data, "survival", 1, "ev_pfs"
)
}
