% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnspatial.R
\name{bnspatial}
\alias{bnspatial}
\title{Spatialize the Bayesian network}
\usage{
bnspatial(
  network,
  target,
  spatialData,
  lookup,
  msk = NULL,
  what = c("class", "entropy"),
  midvals = NULL,
  targetState = NULL,
  spatial = TRUE,
  inparallel = FALSE,
  export = FALSE,
  path = NULL,
  field = NULL,
  verbose = TRUE,
  ...,
  exportRaster = FALSE
)
}
\arguments{
\item{network}{The Bayesian network. An object of class \code{grain}, or a character (the path to the \emph{.net} file to be loaded)}

\item{target}{character. The node of interest to be modelled and mapped.}

\item{spatialData}{character with path to one or more raster files or to a single spatial vector file, or a list of objects of 
class 'RasterLayer' (for raster), or a single object of class 'sf' or 'SpatialPolygonsDataFrame' (for spatial vector). 
The spatial data associated to given network nodes, provided as file paths or as (list of) spatial objects. Items must be ordered 
accordingly to the corresponding nodes listed in \code{lookup}, 
or provided as named list, where names match exactly to the corresponding nodes name.}

\item{lookup}{character (path to file) or a formatted list. This argument can be provided as path to a comma separated file or a formatted list (see \code{\link{setClasses}} )}

\item{msk}{a character (path to raster or vector file), or a bounding box as numeric (xmin,xmax,ymin,ymax), 
or one or more (as list of) rasters of class "RasterLayer", or a single object of class "sf" or "SpatialPolygonsDataFrame". 
The reference data (raster or vector) to be used as mask. All model outputs will have the same extent (outline) as this object. 
All locations with no data (i.e. NA) cells in \code{msk} input will be ignored as well.}

\item{what}{character. The required output, one or more of these are valid:
\itemize{
\item{\code{"class"}} returns the relatively  most likely state.
\item{\code{"entropy"}} calculates the Shannon index and returns the entropy, given the node probabilities.
\item{\code{"probability"}} returns an object for each state of the target node, with its probability.
\item{\code{"expected"}} gives the expected value for the target node (see Details). Only valid for 
target nodes of continuous values. \code{midValues} argument must be provided.
\item{\code{"variation"}} returns the coefficient of variation, as a measure of uncertainty. 
Only valid for target nodes of continuous values.
}}

\item{midvals}{vector of length equal to the number of states of the target node. 
Applies only if the target node is a continuous variable, in which case \code{midvals} must 
contain the mid values for each of the intervals}

\item{targetState}{character. One or more states of interest from the target node. Applies only 
when argument \code{what} includes \code{'probability'}. Default is set to all states of the node.}

\item{spatial}{logical. Should the output be spatially explicit -i.e. a georeferenced raster or spatial vector? 
Default is TRUE, returning an object of class "RasterLayer" or "sf" for polygons. If FALSE, returns a data frame 
with one row for each valid cell/feature from \code{msk} and in columns the output required by \code{what} argument.}

\item{inparallel}{logical or integer. Should the function use parallel processing facilities? Default is FALSE: a single process will be launched. If TRUE, all cores/processors but one will be used.
Alternatively, an integer can be provided to dictate the number of cores/processors to be used.}

\item{export}{Logical or character. Should the spatial output be exported to file? 
Applies only if argument \code{spatial=TRUE}. When \code{export=TRUE}, output will be 
exported in .tif (raster) or .shp (vector) format. For rasters, a character specifying another 
extension can be provided, in which case the 
raster will be exported in that format. Only formats listed by \link[raster]{writeFormats} are valid. 
Argument \code{exportRaster} is deprecated.}

\item{path}{The directory to store the output files, when \code{export} is not FALSE. 
Default is the working directory as from \code{getwd()}. File names are set by a default naming convention, see Details.}

\item{field}{character. Only for spatial vector data (e.g. shapefile), the field/column names in 
the attribute table corresponding to the nodes, ordered accordingly.}

\item{verbose}{logical. If \code{verbose = TRUE} a summary of class boundaries and associated nodes and data will be printed 
to screen for checks.}

\item{...}{Additional arguments to force one or more nodes to a state (i.e. fixing evidence). If the node is 
associated to any input spatial data, the latter will be ignored, thus resulting spatially equal everywhere.
Node name must be provided as argument and the associated fixed state as 
character; both node and state names must be typed exactly as their names in the network.}

\item{exportRaster}{deprecated, use \code{export} instead.}
}
\value{
A list of "RasterLayer" or "SpatialPolygonsDataFrame" objects or a data.frame, depending on input arguments: see \code{\link{mapTarget}}. 
Some basic information about discretization and network/data link are printed on screen during execution.
}
\description{
This function wraps most package functions, to ease the spatial 
implementation of Bayesian networks with minimal coding.
}
\details{
bnspatial

The expected value is calculated by summing the mid values of target node states weighted by their probability: 
\code{p1 * midVal_1 + p2 * midval_2 + ... + pn * midval_n}\cr
When a spatial object is exported to a file, the file name is set by default, accordingly to the following naming convention:
\itemize{
\item{\code{"class"}} \emph{<target node name>}_Class.\emph{<file format  -default .tif>}
\item{\code{"entropy"}} \emph{<target node name>}_ShanEntropy.\emph{<file format  -default .tif>}
\item{\code{"probability"}} \emph{<target node name>}_Probability_.\emph{<targetState>}.\emph{<file format  -default .tif>}
\item{\code{"expected"}} \emph{<target node name>}_ExpectedValue.\emph{<file format  -default .tif>}
\item{\code{"variation"}} \emph{<target node name>}_CoefVariation.\emph{<file format  -default .tif>}
}
An additional comma separated file (.csv) is written to the same directory when \code{"class"}, 
providing a key to interpret the spatial object values and the state they refer to.
}
\examples{
list2env(ConwyData, environment())

network <- LandUseChange
spatialData <- c(ConwyLU, ConwySlope, ConwyStatus)
lookup <- LUclasses

bn <- bnspatial(network, 'FinalLULC', spatialData, lookup)
bn

}
\seealso{
\code{\link{setClasses}}; \code{\link{mapTarget}}; \code{\link{linkNode}}; \code{\link{loadNetwork}}
}
