% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mount.graph.R
\name{mount.graph}
\alias{mount.graph}
\title{Mounts a Bayesian Network graph with graphviz function}
\usage{
mount.graph(bn.averaged, bn.param, graph.name, data.to.work)
}
\arguments{
\item{bn.averaged}{is a Bayesian Network structure learned.}

\item{bn.param}{is a Bayesian Network parameters learned.}

\item{graph.name}{is a name to save the Path Analysis graph.}

\item{data.to.work}{is a data frame containing the variables of the Bayesian Networks learned.}
}
\description{
Using a Bayesian Network structure learned builds a Directly Acyclic Graph (DAG).
}
\details{
This function receives a Bayesian Network structure and parameters learned, a dataset and builds
a DAG showing the parameters on edges.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Load packages
library(bnpa)
library(bnlearn)
# Load datasets from package
data.to.work <- dataQuantC
# Set the name of a text to save the Bayesian Networks parameters
param.name <- "docbnparamHC.txt"
bn.structure <- hc(data.to.work)
# Generates a Bayesian Networks parameters from the Bayesian Networks structure and 
# write a text file with this
bn.param <- gera.bn.param(bn.structure, data.to.work, param.name)
# set the graph name
graph.name <- "imgBNHC"
# Set the option to show or not the parameters on each edge
# Save the graph
mount.graph(bn.structure, bn.param, graph.name, data.to.work)
}
\author{
Elias Carvalho
}

