% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0bnclassify-doc.R
\docType{package}
\name{bnclassify}
\alias{bnclassify}
\title{Learn discrete Bayesian network classifiers from data.}
\description{
State-of-the-art algorithms for learning discrete Bayesian network 
classifiers from data, with functions prediction, model evaluation and inspection.
}
\details{
The learn more about the package, start with the vignettes:
 \code{browseVignettes(package = "bnclassify")}. The following is a list of available
  functionalities: 

Structure learning algorithms:
  \itemize{
    \item \code{\link{nb}}: Naive Bayes (Minsky, 1961)
    \item \code{\link{tan_cl}}: Chow-Liu's algorithm for one-dependence estimators (CL-ODE)  (Friedman et al., 1997)
\item \code{\link{fssj}}: Forward sequential selection and joining (FSSJ) (Pazzani, 1996)
\item \code{\link{bsej}}: Backward sequential elimination and joining (BSEJ)  (Pazzani, 1996)
\item \code{\link{tan_hc}}: Hill-climbing tree augmented naive Bayes (TAN-HC)  (Keogh and Pazzani, 2002)
\item \code{\link{tan_hcsp}}: Hill-climbing super-parent tree augmented naive Bayes (TAN-HCSP) (Keogh and Pazzani, 2002)
\item \code{\link{aode}}: Averaged one-dependence estimators (AODE) (Webb et al., 2005)
}

Parameter learning methods (\code{\link{lp}}):

\itemize{
\item Bayesian and maximum likelihood estimation
\item Weighting attributes to alleviate naive bayes' independence assumption (WANBIA) (Zaidi et al., 2013)
\item Attribute-weighted naive Bayes (AWNB)  (Hall, 2007)
\item Model averaged naive Bayes (MANB) (Dash and Cooper, 2002)
}

Model evaluating:

\itemize{
 \item \code{\link{cv}}: Cross-validated estimate of accuracy 
 \item \code{\link[=logLik.bnc_bn]{logLik}}: Log-likelihood
 \item \code{\link[=AIC.bnc_bn]{AIC}}: Akaike's information criterion (AIC) 
 \item \code{\link[=BIC.bnc_bn]{BIC}}: Bayesian information criterion (BIC) 
}

Predicting: 
\itemize{
\item \code{\link[=predict.bnc_fit]{predict}}: Inference for complete and/or incomplete data (the latter through \code{gRain})}

Inspecting models:
 \itemize{ 
 \item \code{\link[=plot.bnc_dag]{plot}}: Structure plotting (through \code{Rgraphviz})
 \item \code{\link[=print.bnc_base]{print}}: Summary 
 \item \code{\link{params}}: Access conditional probability tables 
 \item \code{\link{nparams}}: Number of free parameters 
 \item and more. See \code{\link{inspect_bnc_dag}} and \code{\link{inspect_bnc_bn}}.
 }
}
\references{
Bielza C and Larranaga P (2014), Discrete Bayesian network 
  classifiers: A survey. \emph{ACM Computing Surveys}, \bold{47}(1), Article 
  5.
  
  Dash D and Cooper GF (2002). Exact model averaging with naive Bayesian 
  classifiers. \emph{19th International Conference on Machine Learning 
  (ICML-2002)}, 91-98.
  
  Friedman N, Geiger D and Goldszmidt M (1997). Bayesian network classifiers.
  \emph{Machine Learning}, \bold{29}, pp. 131--163.
  
  Zaidi NA, Cerquides J, Carman MJ, and Webb GI (2013) Alleviating naive Bayes 
  attribute independence assumption by attribute weighting.
  \emph{Journal of Machine Learning Research}, \bold{14} pp. 1947--1988.  
  
  GI. Webb, JR Boughton, and Z Wang (2005) Not so naive bayes: Aggregating one-dependence 
  estimators. \emph{Machine Learning}, \bold{58}(1) pp. 5--24.  
  
  Hall M (2007). A decision tree-based attribute weighting filter for naive 
  Bayes. \emph{Knowledge-Based Systems}, \bold{20}(2), pp. 120-126.
  
  Koegh E and Pazzani M (2002).Learning the structure of augmented Bayesian 
  classifiers. In \emph{International Journal on Artificial Intelligence 
  Tools}, \bold{11}(4), pp. 587-601.
  
  Koller D, Friedman N (2009). Probabilistic Graphical Models: Principles and
  Techniques. MIT Press.
  
  Pazzani M (1996). Constructive induction of Cartesian product attributes. 
  In \emph{Proceedings of the Information, Statistics and Induction in 
  Science Conference (ISIS-1996)}, pp. 66-77
}
