% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_plot.R
\name{mlm_spaghetti_plot}
\alias{mlm_spaghetti_plot}
\title{Plot fitted values of M and Y from multilevel mediation model}
\usage{
mlm_spaghetti_plot(mod = NULL, d = NULL, id = "id", x = "x", m = "m",
  y = "y", level = 0.95, n = 12, binary_y = FALSE, fixed = TRUE,
  random = TRUE, n_samples = NA)
}
\arguments{
\item{mod}{A multilevel mediation model estimated with \code{mlm()}.}

\item{d}{A \code{data.frame} or a \code{data_frame} used in fitting model.}

\item{id}{Name of id variable (identifying subjects) in data (\code{d}).}

\item{x}{Name of X variable in \code{data}.}

\item{m}{Name of M variable in \code{data}.}

\item{y}{Name of Y variable in \code{data}.}

\item{level}{X level for Credible Intervals. (Defaults to .95.)}

\item{n}{Number of points along X to evaluate fitted values on.
See details.}

\item{binary_y}{Set to TRUE if the outcome variable (Y) is 0/1.}

\item{fixed}{Should the population-level ("fixed") fitted values be shown?}

\item{random}{Should the subject-level ("random") fitted values be shown?}

\item{n_samples}{Number of MCMC samples to use in calculating fitted values.
See details.}
}
\value{
A list of two ggplot2 objects.
}
\description{
Plot population-level fitted values and X% CI, and subject level fitted
values, for M and Y.
}
\details{
If \code{n = 2}, the fitted values will be represented as points
with X% CIs as "error bars". If \code{n > 2}, the representation will be a
line with a Confidence Ribbon instead.
If a very large model is fitted with a large number of MCMC iterations,
the function might take a long time to run. In these cases, users can set
\code{n_samples} to a smaller value (e.g. 1000), in which case the fitted
values (and the CIs) will be based on a random subset of \code{n_samples}
MCMC samples. The default value is NA, meaning that all MCMC samples are
used.
}
\author{
Matti Vuorre \email{mv2521@columbia.edu}
}
