% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{bls_map_county}
\alias{bls_map_county}
\title{Cloropleth mapping of BLS data}
\usage{
bls_map_county(map_data, fill_rate = NULL, labtitle = NULL,
  stateName = NULL, projection = NULL, lowFill = "green",
  highFill = "red")
}
\arguments{
\item{map_data}{Dataframe to be used as the map's measures. Usually a result of 
calls to the \code{get_bls_county()} or \code{get_bls_state()} functions, but other dataframes, 
which include FIPS codes may be used as well.}

\item{fill_rate}{Column name from the dataframe that you want to use as a fill value, in quotes. NOTE: This argument is mandatory!}

\item{labtitle}{The main title label for your map passed as a string. The default is no title.}

\item{stateName}{Optional argument if you only want to map a single state or a group of selected staes. The argument
accepts state full state names in quotes.}

\item{projection}{Choices of map projection are "lambert" or "mercator". By default, the function selects Mercator for single states
and Lambert for nationwide views.}

\item{lowFill}{The fill color of the lower values being mapped. The default color is green, but can be changed to any color accepted by
\code{ggplot2::scale_fill_gradient}.}

\item{highFill}{The fill color of the higher values being mapped. The default color is green, but can be changed to any color accepted by
\code{ggplot2::scale_fill_gradient}.}
}
\description{
Return a ggplot object to render a cloropleth map with county outlines.
The map files contain 2015 FIPS codes and can be used with any data set containing
county and state FIPS codes. They can not be used with the leaflet package but the shape files can be
downloaded from the Census website or with the tigris package. See the "Mapping BLS Data" vignette for this package.
}
\examples{
\dontrun{
# Download the most current month unemployment statistics on a county level.
df <- get_bls_county()

# Map the unemployment rate by county.
bls_gg <- bls_map_county(map_data = df, fill_rate = "unemployed_rate", 
                 labtitle = "Unemployment Rate")
bls_gg


# Map the unemployment rate for Florida and Alabama.

df <- get_bls_county(stateName = c("Florida", "Alabama"))

bls_gg <- bls_map_county(map_data=df, fill_rate = "unemployed_rate", 
stateName = c("Florida", "Alabama"))

bls_gg
}


}
\seealso{
\url{https://cran.r-project.org/package=tigris}
}
\keyword{api}
\keyword{bls}
\keyword{economics}
\keyword{geo}
\keyword{geography}
\keyword{map}
\keyword{unemployment}
