% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/blocks.r
\name{blocks}
\alias{blocks}
\title{Block designs}
\usage{
blocks(treatments, replicates, blocklevels = HCF(replicates),
  searches = max(1, 100 - sum(treatments) - prod(blocklevels)),
  seed = sample(10000, 1), jumps = 1)
}
\arguments{
\item{treatments}{numbers that provide a partition of the total required number of treatments into sets of equally replicated treatments.}

\item{replicates}{replication numbers for each equally replicated treatments set defined by the \code{treatments} list.}

\item{blocklevels}{factor levels that define the number of nested blocks in each succesive blocks stratum taken in order from the highest to the lowest.
The default is the hcf of the replication numbers.}

\item{searches}{maximum number of local optima searched for a design optimization. The default is the maximum of 1 or (100 - total model terms).}

\item{seed}{integer initializing the random number generator. The default is a random seed.}

\item{jumps}{number of pairwise random treatment swaps used to escape a local maxima. The default is a single swap.}
}
\value{
\item{Design}{Data frame giving the optimized block and treatment factors in plot order}
\item{Plan}{Data frame giving a plan view of the treatments in the bottom stratum of the design}
\item{AOV}{Data frame giving a skeleton analysis of variance of the degrees of freedom of the design}
\item{Incidences}{Blocks-by-treatments incidence matrices for each stratum of the design}
\item{Efficiencies}{The achieved A- and D-efficiencies for each stratum of the design together with an A-efficiency upper-bound, where available}
\item{seed}{Numerical seed for random number generator}
\item{searches}{Maximum number of searches in each stratum}
\item{jumps}{Number of random treatment swaps to escape a local maxima}
}
\description{
Constructs randomized nested block designs for unstructured treatments where treatments can have arbitrary levels of replication
and blocks can have arbitrary depth of nesting.
}
\details{
The \code{treatments} and \code{replicates} lists define a partition of the total required number of treatments into equally replicated treatment sets where
\code{treatments} is a list of set sizes and \code{replicates} is a matching list of replication numbers.
 The sum of the set sizes is the total number of treatments and the sum of the cross-products of the set sizes
 and the replication numbers is the total number of units. Treatments are numbered consecutively according to
 the numbers of treatments in the consecutive treatment sets.

The \code{blocklevels} list defines the number of nested blocks in each blocks stratum taken in order from the highest to the lowest stratum. The
first number is the number of main blocks, the second number, if any, is the number of sub-blocks nested in each main block, the third
number, if any, is the number of sub-sub-blocks nested in each sub-block,and so on for all the reqired blocks strata.
The default is the highest common factor of the replication numbers and defines a design with the maximum possible number of
orthogonal main blocks. Block sizes are always as equal as possible and never differ by more than a single unit in any particular stratum of the design.

 Block designs for k replicates of v**2 treatments with k complete main blocks of size v**2 and v incomplete blocks of size v in each main block
 where k < (v+2) if v is prime or prime-power, k < 5 if v = 10, or k < 4 generally, are lattice block designs and are constructed algebraically.
 All other non-orthogonal block designs are constructed by a D-optimality swapping algorithm that makes improving swaps between
 blocks until a local optima is atttained and no further improvement is possible. The swapping algorithm always works from the top stratum downwards and
 is always constrained to make improving swaps within the levels of any existing blocks.

 Lattice designs where v is a prime-power require the \code{\link[crossdes]{MOLS}} package.

 The principle design outputs comprise:
\itemize{
 \item  A design matrix showing the allocation of treatments to blocks with successive nested blocks factors arranged in successive columns in standard block order.  \cr
 \item  A design matrix as above but with the last (bottom) blocks factor shown arranged horizontally to give a plan view. \cr
 \item  A set of incidence matrices, one for each blocks stratum, showing the number of times each treatment occurs in each block for each stratum. \cr
 \item  A table showing the achieved D- and A-efficiency factors for each nested blocks stratum together with an A-efficiency upper bound, where available. \cr
 \item  A table showing a skeleton analysis of degrees of freedom for the combined block and treatment design. \cr
}
}
\examples{
# 3 treatments x 2 replicates, 2 treatments x 4 replicates and 4 treatments x 3 replicates
# the hcf of the replication numbers is 1 therefore the default design is completely randomized
blocks(treatments=c(3,2,4),replicates=c(2,4,3))

# 4 treatments x 4 replicates with 2 main blocks each containing two complete replicates
blocks(treatments=4,replicates=4,blocklevel=2)

# 50 treatments x 4 replicates with 4 main blocks and 5 nested sub-blocks in each main block
blocks(treatments=50,replicates=4,blocklevels=c(4,5))

# as above but with 20 additional single replicate treatments
# giving exactly one single replicate treatment per sub-block
blocks(treatments=c(50,20),replicates=c(4,1),blocklevels=c(4,5))

# 64 treatments x 2 replicates with 2 main blocks and five succesively nested 2-level factors
blocks(treatments=64,replicates=2,blocklevels=c(2,2,2,2,2,2))

# concurrence matrix of balanced incomplete block design
crossprod(blocks(13,4,13,searches=100)$Incidences[[1]])

# concurrence matrix for 13 treatments x 4 replicates and 13 treatments with one rep in 13 blocks
crossprod(blocks(c(13,13),c(4,1),13)$Incidences[[1]])

# 2**10 treatments x 2 replicates in 2**10 blocks giving a fully saturated blocks design
# (requires a considerable time to run!)
\dontrun{ d=blocks(1024,2,rep(2,10)) }
}
\references{
Sailer, M. O. (2013). crossdes: Construction of Crossover Designs. R package version 1.1-1. http://CRAN.R-project.org/package=crossdes
}

