% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-logging.R
\name{write_log}
\alias{write_log}
\alias{log_fatal}
\alias{log_error}
\alias{log_warn}
\alias{log_info}
\alias{log_debug}
\alias{log_trace}
\alias{as_log_level}
\alias{get_log_level}
\alias{cnd_logger}
\alias{cat_logger}
\title{Logging}
\usage{
write_log(..., level = "info")

log_fatal(...)

log_error(...)

log_warn(...)

log_info(...)

log_debug(...)

log_trace(...)

as_log_level(level)

get_log_level()

cnd_logger(msg, level)

cat_logger(msg, level)
}
\arguments{
\item{...}{Concatenated as \code{paste0(..., "\\n")}}

\item{level}{Logging level (possible values are "fatal", "error", "warn",
"info", "debug" and "trace"}

\item{msg}{Message (string)}
}
\value{
Logging function \code{write_log()}, wrappers \verb{log_*()} and loggers
provided as \code{cnd_logger()}/cat_logger() all return \code{NULL} invisibly and are
called for their side effect of emitting a message. Helpers \code{as_log_level()}
and \code{get_log_level()} return a scalar-valued ordered factor.
}
\description{
Internally used infrastructure for emitting log messages is exported, hoping
that other packages which depend on this, use it and thereby logging is
carried out consistently both in terms of presentation and output device.
All log messages are associated with an (ordered) level ("fatal", "error",
"warn", "info", "debug" or "trace") which is compared against the currently
set value (available as \code{get_log_level()}) and output is only generated if
the message level is greater or equal to the currently set value.
}
