% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack-class.R, R/stacks-class.R
\name{new_stack}
\alias{new_stack}
\alias{is_stack}
\alias{stack_blocks}
\alias{stack_blocks<-}
\alias{stack_name}
\alias{stack_name<-}
\alias{validate_stack}
\alias{as_stack}
\alias{stacks}
\alias{is_stacks}
\alias{as_stacks}
\title{Stacks}
\usage{
new_stack(blocks = character(), name = NULL, ..., class = character())

is_stack(x)

stack_blocks(x)

stack_blocks(x) <- value

stack_name(x, name)

stack_name(x) <- value

validate_stack(x)

as_stack(x)

stacks(...)

is_stacks(x)

as_stacks(x, ...)
}
\arguments{
\item{blocks}{Set of blocks}

\item{name}{Stack name}

\item{...}{Extensibility}

\item{class}{(Optional) stack sub-class}

\item{x}{Stack object}

\item{value}{Replacement value}
}
\value{
Construction and coercion via \code{new_stack()}/\code{as_stack()} and
\code{stacks()}/\code{as_stacks()} results in \code{stack} and \code{stacks} objects,
respectively, while inheritance testing via \code{is_stack()} and \code{is_stacks()}
returns scalar logicals. Attribute getters \code{stack_name()} and
\code{stack_blocks()} return scalar and vector-valued character vectors while
setters \verb{stack_name()<-} and \verb{stack_blocks()<-} return modified stack
objects.
}
\description{
Multiple (related) blocks can be grouped together into stacks. Such a
grouping has no functional implications, rather it is an organizational tool
to help users manage more complex pipelines. Stack objects constitute a set
of attributes, the most important of which is \code{blocks} (a character vector
of block IDs). Each \code{stack} may have an arbitrary \code{name} and the class can
be extended by adding further attributes, maybe something like \code{color},
coupled with sub-classing.

Stack container objects (\code{stacks} objects) can be created with \code{stacks()}
or \code{as_stacks()} and inheritance can be tested via \code{is_stacks()}. Further
basic operations such as concatenation, subsetting and sub-assignments is
available by means of base R generics.
}
\details{
Individual stacks can be created using \code{new_stack()} or \code{as_stack()} and
inheritance can be tested with \code{is_stack()}. Attributes can be retrieved
(and modified) with \code{stack_blocks()}/\verb{stack_blocks<-()} and
\code{stack_name()}/\verb{stack_name<-()}, while validation is available as
(generic) \code{validate_stack()}.
}
\examples{
stk <- new_stack(letters[1:5], "Alphabet 1")

stack_blocks(stk)
stack_name(stk)
stack_name(stk) <- "Alphabet start"

stks <- c(start = stk, cont = new_stack(letters[6:10], "Alphabet cont."))
names(stks)

tryCatch(
  stack_blocks(stks[[2]]) <- letters[4:8],
  error = function(e) conditionMessage(e)
)

}
