# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

compute_dynseg_cpp <- function(suff_stats, family, ncol, min_block_size, max_blocks, pen_func) {
    .Call(`_blockcpd_compute_dynseg_cpp`, suff_stats, family, ncol, min_block_size, max_blocks, pen_func)
}

compute_hierseg_cpp <- function(suff_stats, family, ncol, min_block_size, max_blocks, pen_func, algorithm_type) {
    .Call(`_blockcpd_compute_hierseg_cpp`, suff_stats, family, ncol, min_block_size, max_blocks, pen_func, algorithm_type)
}

compute_suff_stats_cpp <- function(data_mat, family) {
    .Call(`_blockcpd_compute_suff_stats_cpp`, data_mat, family)
}

#' @title
#' Rand Index Function for change point detection
#'
#' @description
#' Computes the rand Index (non-adjusted) for the change point sets. A specific
#' equation for change point detection is used to make the computation faster.
#' Proof of correctness of the equation is given in the dissertation.
#'
#' @param cp1 Change point set for model 1 or true change point set.
#' @param cp2 Change point set for model 2 or true change point set.
#' @param m The size of the vector array.
#'
compute_rand <- function(cp1, cp2, m) {
    .Call(`_blockcpd_compute_rand`, cp1, cp2, m)
}

#' @title
#' Hausdorff distance metric
#'
#' @description
#' Computes the Hausdorff distance between change point sets.
#'
#' @param cp1 Change point set for model 1 or true change point set.
#' @param cp2 Change point set for model 2 or true change point set.
compute_hausdorff <- function(cp1, cp2) {
    .Call(`_blockcpd_compute_hausdorff`, cp1, cp2)
}

#' @title
#' Symmetric difference metric
#'
#' @description
#' Computes the size of the symmetric difference between two change point
#' detection sets
#'
#' @param cp1 Change point set for model 1 or true change point set.
#' @param cp2 Change point set for model 2 or true change point set.
compute_symdiff <- function(cp1, cp2) {
    .Call(`_blockcpd_compute_symdiff`, cp1, cp2)
}

#' @title
#' Jaccard's Index metric
#'
#' @description
#' Computes the Jaccard index between two change point
#' detection sets
#'
#' @param cp1 Change point set for model 1 or true change point set.
#' @param cp2 Change point set for model 2 or true change point set.
compute_jaccard <- function(cp1, cp2) {
    .Call(`_blockcpd_compute_jaccard`, cp1, cp2)
}

rcpd_cpp <- function(family, n, m, changepoints, parameters) {
    .Call(`_blockcpd_rcpd_cpp`, family, n, m, changepoints, parameters)
}

