% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v2_spatialAutoRange.R
\name{spatialAutoRange}
\alias{spatialAutoRange}
\title{Measure spatial autocorrelation in the predictor raster files}
\usage{
spatialAutoRange(
  rasterLayer,
  sampleNumber = 5000L,
  border = NULL,
  speciesData = NULL,
  doParallel = NULL,
  nCores = NULL,
  showPlots = TRUE,
  degMetre = 111325,
  maxpixels = 1e+05,
  plotVariograms = FALSE,
  progress = TRUE
)
}
\arguments{
\item{rasterLayer}{A raster object of covariates to find spatial autocorrelation range.}

\item{sampleNumber}{Integer. The number of sample points of each raster layer to fit variogram models. It is 5000 by default,
however it can be increased by user to represent their region well (relevant to the extent and resolution of rasters).}

\item{border}{deprecated option!}

\item{speciesData}{A spatial or sf object (optional). If provided, the \code{sampleNumber} is ignored and
variograms are created based on species locations. This option is not recommended if the species data is not
evenly distributed across the whole study area and/or the number of records is low.}

\item{doParallel}{deprecated option!}

\item{nCores}{deprecated option!}

\item{showPlots}{Logical. Show final plot of spatial blocks and autocorrelation ranges.}

\item{degMetre}{Numeric. The conversion rate of metres to degree. This is for constructing spatial
blocks for visualisation. When the input map is in geographic coordinate system (decimal degrees), the block size is
calculated based on deviding the calculated \emph{range} by this value to convert to the input map's unit
(by default 111325; the standard distance of a degree in metres, on the Equator).}

\item{maxpixels}{Number of random pixels to select the blocks over the study area.}

\item{plotVariograms}{deprecated option!}

\item{progress}{Logical. Shows progress bar. It works only when \code{doParallel = FALSE}.}
}
\description{
This function is deprecated and will be removed in future updates! Please use \code{\link{cv_spatial_autocor}} instead!
}
\seealso{
\code{\link{cv_spatial_autocor}}
}
