% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FarringtonManning.R
\name{adjusted_alpha,FarringtonManning-method}
\alias{adjusted_alpha,FarringtonManning-method}
\title{Adjusted level of significance}
\usage{
\S4method{adjusted_alpha}{FarringtonManning}(
  design,
  n1,
  nuisance,
  nuis_ass,
  precision = 0.001,
  gamma = 0,
  recalculation,
  allocation = c("exact", "approximate"),
  ...
)
}
\arguments{
\item{design}{Object of class \code{FarringtonManning} created
by \code{setupFarringtonManning}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the total sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter in (0,1). For the
Farrington-Manning test this is the overall response rate.}

\item{nuis_ass}{If \code{recalculation = FALSE} this is the value for
the overall response rate that is used to calculate the sample size
for the adjusted significance level.}

\item{precision}{Value by which the nominal type 1 error rate is
reduced in each iteration until the nominal type 1 error rate is
preserved.}

\item{gamma}{If \code{gamma > 0} then the significance level is adjusted
such that the actual level is at most \code{alpha - gamma}. This is
necessary to maintain the nomininal significance level if a confidence
interval approach proposed by Friede & Kieser (2011) is used.}

\item{recalculation}{Should the sample size be recalculated after n1
n1 patients are recruited?}

\item{allocation}{Whether the allocation ratio should be preserved
exactly (\code{exact}) or approximately (\code{approximate}).}

\item{...}{Further optional arguments.}
}
\value{
Value of the adjusted significance level for every nuisance
 parameter and every value of n1.
}
\description{
This method returns an adjusted significance level that can be used
such that the actual type I error rate is preserved.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.
}
\examples{
d <- setupFarringtonManning(alpha = 0.025, beta = 0.2, r = 1, delta = 0, delta_NI = 0.25)
adjusted_alpha(d, n1 = 20, nuisance = 0.5, recalculation = TRUE)

}
