% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_credentials.R
\name{create_smtp_creds_file}
\alias{create_smtp_creds_file}
\title{Store SMTP credentials in a file}
\usage{
create_smtp_creds_file(file, user = NULL, provider = NULL,
  host = NULL, port = NULL, use_ssl = NULL)
}
\arguments{
\item{file}{The output filename for the credentials file.}

\item{user}{The username for the email account. Typically, this is the email
address associated with the account.}

\item{provider}{An optional email provider shortname for autocompleting STMP
configuration details (the \code{host}, \code{port}, \code{use_ssl} options). Options
currently include \code{gmail}, \code{outlook}, and \code{office365}. If nothing is
provided then values for \code{host}, \code{port}, and \code{use_ssl} are expected.}

\item{host, port, use_ssl}{Configuration info for the SMTP server. The \code{host}
and \code{port} parameters are the address and port for the SMTP server;
\code{use_ssl} is an option as to whether to use SSL: supply a \code{TRUE} or \code{FALSE}
value.}
}
\description{
We can create a file with SMTP configuration and access credentials for the
purpose of more easily sending email messages through \code{\link[=smtp_send]{smtp_send()}}. With
this file produced, the credentials helper \code{\link[=creds_file]{creds_file()}} can be used in the
\code{credentials} argument of \code{\link[=smtp_send]{smtp_send()}}.
}
\examples{
# Create a credentials file to make it
# much easier to send email out through
# Gmail with `smtp_send()`; name the
# file "gmail_creds"

# create_smtp_creds_file(
#   file = "gmail_creds",
#   user = "user_name@gmail.com",
#   provider = "gmail"
#   )

}
