% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{CLPs}
\alias{CLPs}
\title{Format aesthetics for the category level points}
\usage{
CLPs (bp,  which = 1:ncol(bp$Xcat), col = "black", cex = 0.6)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{which}{a vector containing the columns or variables for which the CLPs should be displayed, with default \code{ncol(Xcat)}.}

\item{col}{the colour(s) for the CLPs, with default \code{black}.}

\item{cex}{the character expansion(s) for the CLPs, with default \code{0.6}.}
}
\value{
The object of class \code{biplot} will be appended with a list called \code{CLP.aes} containing the following elements  A list with the following components is available:
\item{which}{a vector containing the columns or variables for which the CLPs are displayed.}
\item{col}{the colour(s) of the CLPs.}
\item{cex}{the character expansion(s) of the plotting characters of the CLPs.}
}
\description{
This function allows the user to format the aesthetics for the category level points (CLPs).
}
\examples{
mtdf <- as.data.frame(mtcars)
mtdf$cyl <- factor(mtdf$cyl)
mtdf$vs <- factor(mtdf$vs)
mtdf$am <- factor(mtdf$am)
mtdf$gear <- factor(mtdf$gear)
mtdf$carb <- factor(mtdf$carb)
biplot(mtdf[,-11], scaled = TRUE) |> AoD(classes = mtdf[,11]) |> 
CLPs(col = list(rep("olivedrab",3), rep("orange",2),
                rep("coral",2), rep("brown",3))) |> 
plot()

}
\seealso{
\code{\link{biplot}}, \code{\link{CA}}, \code{\link{AoD}}
}
