% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam_helpers.R
\name{grid_from_region}
\alias{grid_from_region}
\title{Creates grid for a given geographic region}
\usage{
grid_from_region(region, cell_size, complete_cover = TRUE)
}
\arguments{
\item{region}{SpatialPolygonsDataFrame of the region of interest. Object must
be unprojected, World Geodetic System (WGS84).}

\item{cell_size}{(numeric) resolution for grid (single number or vector of
two numbers) in kilometers (km).}

\item{complete_cover}{(logical) whether or not to include cells of grid
partially overlapped with region. Default = TRUE.}
}
\value{
Gridded SpatialPolygonsDataFrame for the region of interest. Each grid cell
is related to a specific ID and longitude and latitude coordinates.
}
\description{
Divides the region of interest in a grid of a specific cell size.
}
\examples{
# Data
data("mx", package = "biosurvey")

# Create grid from polygon
grid_reg <- grid_from_region(region = mx, cell_size = 100)

sp::plot(grid_reg)
grid_reg
}
