% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bar.R
\name{plot_bar}
\alias{plot_bar}
\title{Create Simple Professional Bar Plots}
\usage{
plot_bar(
  data,
  x,
  y = NULL,
  group = NULL,
  facet = NULL,
  position = c("dodge", "stack", "fill"),
  stat = NULL,
  colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  legend_title = NULL,
  flip = FALSE,
  values = FALSE
)
}
\arguments{
\item{data}{A data frame containing the variables to plot}

\item{x}{Character string specifying the x-axis variable.}

\item{y}{Character string specifying the y-axis variable. If NULL, counts calculated automatically. Default: NULL.}

\item{group}{Character string specifying the grouping variable for fill color. Default: NULL.}

\item{facet}{Character string specifying the faceting variable. Default: NULL.}

\item{position}{Character string specifying bar position: "dodge", "stack", or "fill".}

\item{stat}{Character string for statistical aggregation: "mean" or "median".}

\item{colors}{Character vector of colors. If NULL, uses TealGrn palette. Default: NULL.}

\item{title}{Character string for plot title. Default: NULL.}

\item{xlab}{Character string for x-axis label. Default: NULL.}

\item{ylab}{Character string for y-axis label. Default: NULL.}

\item{legend_title}{Character string for legend title. Default: NULL.}

\item{flip}{Logical parameter indicating whether to flip coordinates. Default: FALSE.}

\item{values}{Logical parameter indicating whether to display value labels above bars. Default: FALSE.}
}
\value{
A ggplot2 object
}
\description{
Generates publication-ready bar plots with minimal code using ggplot2.
}
\examples{
# Simulated clinical data
clinical_df <- clinical_data()

# Proportion of response by treatment
plot_bar(data = clinical_df, x = "treatment", group = "response", position = "fill", 
        title = "Proportion of response by treatment", values = TRUE)
         
# Grouped barplot of categorical variable by treatment with value labels
plot_bar(data = clinical_df, x = "response", group = "visit", facet = "treatment", 
        title = "Response by visit and treatment",values = TRUE)
        
}
