% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_SampleBinaryVector.R
\name{bm_SampleBinaryVector}
\alias{bm_SampleBinaryVector}
\title{Sample binary vector}
\usage{
bm_SampleBinaryVector(obs, ratio, as.logical = FALSE, seedval = NULL)
}
\arguments{
\item{obs}{a \code{vector} containing binary values (either \code{0} or \code{1})}

\item{ratio}{a \code{numeric} between \code{0} and \code{1} corresponding to the proportion 
of \code{obs} values to sample}

\item{as.logical}{(\emph{optional, default} \code{FALSE}) \cr 
A \code{logical} value defining whether output should be returned as a \code{vector} of 
\code{TRUE/FALSE} values or \code{integer} values corresponding to the indices of \code{obs} 
elements to be kept}

\item{seedval}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} value corresponding to the new seed value to be set}
}
\value{
A \code{list} containing the following elements :
\itemize{
  \item \code{calibration} : elements selected for calibration
  \item \code{validation} : elements selected for validation (complementary to the 
  calibration set)
}
}
\description{
This internal \pkg{biomod2} function allows the user to sample a binary vector 
keeping the same proportion of \code{0} and \code{1} as the initial vector.
}
\examples{
## Generate a binary vector
vec.a <- sample(c(0, 1), 100, replace = TRUE)

## Generate calibration / validation datasets
bm_SampleBinaryVector(obs = vec.a, ratio = 0.7)


}
\seealso{
Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelingOptions}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges
}
\concept{Secondary functions}
\keyword{binary}
\keyword{sample}
