% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrhenius_model.R
\name{dArrhenius_model}
\alias{dArrhenius_model}
\title{First derivative of the Arrhenius model}
\usage{
dArrhenius_model(t, x, parms, temp_profile)
}
\arguments{
\item{t}{numeric vector indicating the time of the experiment.}

\item{x}{list with the value of N at t.}

\item{parms}{parameters for the secondary model. No explicit check of their
validity is performed.}

\item{temp_profile}{a function that provides the temperature at a given
time.}
}
\value{
The value of the first derivative of \eqn{N} at time \code{t} as a
        list.
}
\description{
Calculates the first derivative of the Arrhenius model with log-linear
inactivation
for dynamic problems at a given time for the model parameters provided and
the environmental conditions given.
}
\details{
This function is compatible with the function
\code{\link{predict_inactivation}}.
}
\section{Model Equation}{


   \deqn{\frac{dN}{dt} = - k * N }{
         dN/dt = - k * n}
}

\section{Model parameters}{

     \itemize{
         \item temp_ref: Reference temperature for the calculation,
         \item k_ref: inactivation rate at the ref. temp.
         \item Ea: Activation energy.
         }
}

\seealso{
\code{\link{predict_inactivation}}
}
