% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_interpolation.R
\name{build_temperature_interpolator}
\alias{build_temperature_interpolator}
\title{Continuum Interpolation of Discrete Temperatures Values}
\usage{
build_temperature_interpolator(temperature_data)
}
\arguments{
\item{temperature_data}{data frame with the values of the temperatures at
each value of time. It need to have 2 columns, named time and
temperature.}
}
\value{
a list with with two elements: \itemize{
     \item temp, the interpolator of the temperature and
     \item dtemp, the interpolator of its first derivative
}
}
\description{
Builds an interpolator of the temperature at each time and its first
derivative.
First derivatives are approximated using forward finite
differences (\code{\link{approxfun}}). It is assumed that temperature is 0
and constant outside the time interval provided.
}
\seealso{
\code{\link{approxfun}}
}
