% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_multi_dynamic.R
\name{fit_multiple_growth_MCMC}
\alias{fit_multiple_growth_MCMC}
\title{Fitting growth models to multiple dynamic experiments using MCMC}
\usage{
fit_multiple_growth_MCMC(
  starting_point,
  experiment_data,
  known_pars,
  sec_model_names,
  niter,
  ...
)
}
\arguments{
\item{starting_point}{a named vector with the starting values of the model parameters
to estimate from the data.}

\item{experiment_data}{a nested list with the experimental data. Each entry describes
one experiment as a list with two elements: data and conditions. \code{data} is a tibble
with two columns: time and logN. \code{conditions} is a tibble with one column named time
and as many additional columns as environmental factors.}

\item{known_pars}{named vector of known model parameters}

\item{sec_model_names}{named character vector with names the
environmental conditions and values the secondary model (see secondary_model_data).}

\item{niter}{number of samples of the MCMC algorithm.}

\item{...}{additional arguments for \code{modMCMC} (e.g. upper and lower bounds).}
}
\value{
An instance of \code{\link{FitMultipleGrowthMCMC}}.
}
\description{
This functions enables to fit a growth model using a dataset comprised of
several experiments with potentially different dynamic experimental conditions.
}
\examples{
\donttest{
## We will use the multiple_experiments data set

data("multiple_experiments")

## For each environmental factor, we need to defined a model

sec_names <- c(temperature = "CPM", pH = "CPM")

## Any model parameter can be fixed

known <- list(Nmax = 1e8, N0 = 1e0, Q0 = 1e-3,
    temperature_n = 2, temperature_xmin = 20, temperature_xmax = 35,
    pH_n = 2, pH_xmin = 5.5, pH_xmax = 7.5, pH_xopt = 6.5)

## The rest require starting values for model fitting

start <- list(mu_opt = .8, temperature_xopt = 30)

## We can now call the fitting function

set.seed(12412)
global_MCMC <- fit_multiple_growth_MCMC(start, multiple_experiments, known, sec_names, niter = 1000,
   lower = c(.2, 29),  # lower limits of the model parameters
   upper = c(.8, 34))  # upper limits of the model parameters

## Parameter estimates can be retrieved with summary

summary(global_MCMC)

## We can compare fitted model against observations

plot(global_MCMC)

## Any single environmental factor can be added to the plot using add_factor

plot(global_MCMC, add_factor = "temperature")
}

}
