% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kl_divergence.R
\name{calc_kl}
\alias{calc_kl}
\title{Calculate KL divergence of features}
\usage{
calc_kl(feature, target_b, len_target, pos_target, ES)
}
\arguments{
\item{feature}{feature vector.}

\item{target_b}{target in bits (as per \code{\link[bit]{as.bit}}).}

\item{len_target}{length of target vector.}

\item{pos_target}{number of positive cases in target vector.}

\item{ES}{numeric value of target entropy.}
}
\value{
a \code{integer} vector of length equal to the number of features
containing computed information gain values.
}
\description{
Computes Kullback-Leibler divergence between features and target vector.
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0
and 1 values.
}
\examples{
tar <- sample(0L:1, 100, replace = TRUE)
feat <- sample(0L:1, 100, replace = TRUE)
prop <- c(100 - sum(tar), sum(tar))/100
entr <- - sum(prop*log(prop))
library(bit) #used to code vector as bit
calc_kl(feat, as.bit(tar), 100, sum(tar), entr)
}
\references{
STH here
}
\seealso{
\code{\link{test_features}}.

Kullback-Leibler divergence is calculated using \code{\link[entropy]{KL.plugin}}.
}

