% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calc_ig}
\alias{calc_ig}
\title{Calculate IG of features}
\usage{
calc_ig(target, features)
}
\arguments{
\item{target}{target vector.}

\item{features}{\code{integer} matrix of features with number of rows equal
to the length of target vector.}
}
\value{
a \code{integer} vector of length equal to the number of features
containing computed information gain values.
}
\description{
Computes information gain between features and target vector.
}
\note{
Both \code{target} and \code{features} must be binary, i.e. contain only 0
and 1 values.

During calculations \eqn{0 \log 0  = 0}. For justification see References.
}
\examples{
calc_ig(sample(0L:1, 100, replace = TRUE), matrix(sample(0L:1, 400, replace = TRUE), ncol = 4))
}
\references{
Cover TM, Thomas JA \emph{Elements of Information Theory, 2nd Edition}
Wiley, 2006.
}
\seealso{
\code{\link{test_features}}.

Other implemented \code{\link{criterions}}.
Subroutine used in \code{\link[base]{apply}} statement in \code{calc_ig}:
\code{\link{calc_ig_single}}
}

