% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose-description.R
\name{compose_description_v1.3.0}
\alias{compose_description_v1.3.0}
\alias{compose_description}
\title{Compose BioCompute Object - Description Domain (v1.3.0)}
\usage{
compose_description_v1.3.0(
  keywords = NULL,
  xref = NULL,
  platform = "Seven Bridges Platform",
  pipeline_meta = NULL,
  pipeline_prerequisite = NULL,
  pipeline_input = NULL,
  pipeline_output = NULL
)

compose_description(
  keywords = NULL,
  xref = NULL,
  platform = "Seven Bridges Platform",
  pipeline_meta = NULL,
  pipeline_prerequisite = NULL,
  pipeline_input = NULL,
  pipeline_output = NULL
)
}
\arguments{
\item{keywords}{Character vector. A list of keywords to aid in
searchability and description of the experiment.}

\item{xref}{Data frame. A list of the databases and/or ontology IDs
that are cross-referenced in the BCO.}

\item{platform}{Character string. Reference to a particular deployment
of an existing platform where this BCO can be reproduced.}

\item{pipeline_meta}{Data frame. Pipeline metadata.
Variables include \code{step_number}, \code{name}, \code{description},
and \code{version}.}

\item{pipeline_prerequisite}{Data frame. Packages or prerequisites
for running the tools used. Variables include \code{step_number},
\code{name}, \code{uri}, and \code{access_time}.}

\item{pipeline_input}{Data frame. Input files for the tools.
Variables include \code{step_number}, \code{uri}, and \code{access_time}.}

\item{pipeline_output}{Data frame. Output files for the tools.
Variables include \code{step_number}, \code{uri}, and \code{access_time}.}
}
\value{
A list of class \code{bco.domain}
}
\description{
Compose BioCompute Object - Description Domain (v1.3.0)
}
\examples{
keywords <- c("HCV1a", "Ledipasvir", "antiviral resistance", "SNP", "amino acid substitutions")
xref <- data.frame(
  "namespace" = c("pubchem.compound", "pubmed", "so", "taxonomy"),
  "name" = c("PubChem-compound", "PubMed", "Sequence Ontology", "Taxonomy"),
  "ids" = I(list(
    "67505836",
    "26508693",
    c("SO:000002", "SO:0000694", "SO:0000667", "SO:0000045"),
    "31646"
  )),
  "access_time" = c(
    as.POSIXct("2017-01-20T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-21T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-22T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-23T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST")
  ),
  stringsAsFactors = FALSE
)

platform <- "Seven Bridges Platform"

pipeline_meta <- data.frame(
  "step_number" = c("1"),
  "name" = c("HIVE-hexagon"),
  "description" = c("Alignment of reads to a set of references"),
  "version" = c("1.3"),
  stringsAsFactors = FALSE
)

pipeline_prerequisite <- data.frame(
  "step_number" = rep("1", 5),
  "name" = c(
    "Hepatitis C virus genotype 1",
    "Hepatitis C virus type 1b complete genome",
    "Hepatitis C virus (isolate JFH-1) genomic RNA",
    "Hepatitis C virus clone J8CF, complete genome",
    "Hepatitis C virus S52 polyprotein gene"
  ),
  "uri" = c(
    "https://www.ncbi.nlm.nih.gov/nuccore/22129792",
    "https://www.ncbi.nlm.nih.gov/nuccore/5420376",
    "https://www.ncbi.nlm.nih.gov/nuccore/13122261",
    "https://www.ncbi.nlm.nih.gov/nuccore/386646758",
    "https://www.ncbi.nlm.nih.gov/nuccore/295311559"
  ),
  "access_time" = c(
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST")
  ),
  stringsAsFactors = FALSE
)

pipeline_input <- data.frame(
  "step_number" = rep("1", 2),
  "uri" = c(
    "https://example.com/dna.cgi?cmd=objFile&ids=514683",
    "https://example.com/dna.cgi?cmd=objFile&ids=514682"
  ),
  "access_time" = c(
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST")
  ),
  stringsAsFactors = FALSE
)

pipeline_output <- data.frame(
  "step_number" = rep("1", 2),
  "uri" = c(
    "https://example.com/data/514769/allCount-aligned.csv",
    "https://example.com/data/514801/SNPProfile*.csv"
  ),
  "access_time" = c(
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST"),
    as.POSIXct("2017-01-24T09:40:17", format = "\%Y-\%m-\%dT\%H:\%M:\%S", tz = "EST")
  ),
  stringsAsFactors = FALSE
)

compose_description(
  keywords, xref, platform,
  pipeline_meta, pipeline_prerequisite, pipeline_input, pipeline_output
) \%>\% convert_json()
}
