\name{example.data}
\docType{data}
\alias{example.data}
\alias{kinesin}
\alias{transducin}
\alias{pdbs}
\alias{core}
\alias{annotation}
\alias{hivp}
\title{Bio3d Example Data}
\description{
  These data sets contain the results of running various Bio3D
  functions on example kinesin and transducin structural data, and on a short 
  coarse-grained MD simulation data for HIV protease. The main 
  purpose of including this data (which may be generated by the user by following the extended examples documented within the various Bio3D functions) is to
  speed up example execution. It should allow users to more quickly
  appreciate the capabilities of functions that would otherwise require
  raw data download, input and processing before execution.

  Note that related datasets formed the basis of
  the work described in (Grant, 2007) and (Yao & Grant, 2013) for \code{kinesin}
  and \code{transducin} examples, respectively.
}
\usage{
data(kinesin)
data(transducin)
data(hivp)
}
\format{
  Three objects from analysis of the \code{kinesin} and \code{transducin} sequence and structure
  data:
  \enumerate{
    \item{pdbs}{ is a list of class \code{"pdbs"} containing aligned PDB
      structure data.  In the case of transducin this is the output of running
      \code{\link{pdbaln}} on a set of 47 kinesin structures from the SCOP database (again see \code{pdbs$id} for details). In both cases the coordinates
      are fitted onto the first structure based on \code{"core"} positions obtained from \code{\link{core.find}} and superposed using the function 
      \code{\link{pdbfit}}. }
    \item{core}{ is a list of class \code{"core"} obtained by running the
      function \code{\link{core.find}} on the \code{pdbs} object as described above.}
    \item{annotation}{ is a character matrix describing the nucleotide state and bound 
      ligand species for each structure in \code{pdbs} as obtained from the function \code{\link{pdb.annotate}}.}
  }

  One object named \code{net} in the hivp example data stores the correlation 
  network obtained from the analysis of the MD simulation trajectory of HIV 
  protease using the \code{cna} function. The original trajectory file can be 
  accessed by the command \sQuote{system.file("examples/hivp.dcd", package="bio3d")}. 

}
\source{
  A related but more extensive dataset formed the basis of
  the work described in (Grant, 2007) and (Yao & Grant, 2013) for \code{kinesin}
  and \code{transducin} examples, respectively.
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.

  Grant, B.J. et al. (2007) \emph{J. Mol. Biol.} \bold{368}, 1231--1248.
  
  Yao, X.Q. et al. (2013) \emph{Biophys. J.} \bold{105}, L08--L10.
}
\keyword{datasets}
