% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIKM1_LBM_Binary-class.R
\name{plot,BIKM1_LBM_Binary-method}
\alias{plot,BIKM1_LBM_Binary-method}
\title{Plot method for a \code{\linkS4class{BIKM1_LBM_Binary}} object}
\usage{
\S4method{plot}{BIKM1_LBM_Binary}(x, y, ...)
}
\arguments{
\item{x}{an object of class \code{BIKM1_LBM_Binary}.}

\item{y}{binary matrix of observations.}

\item{...}{in the plot method, additional parameters (ignored)}
}
\value{
One \pkg{plot} and three \pkg{ggplot2} objects.
}
\description{
Produce respectively one plot of two-dimensional segmentation of a \code{BIKM1_LBM_Binary} fit, a plot of evolution of  the chosen criterion as a function of the number of row and column clusters, and a boxplot of conditional posteriors for each row and column cluster.
}
\examples{
\donttest{require(bikm1)
g=5
h=3
theta=list()
theta$pi_g=t(1/g*rep(1,g))
theta$rho_h=t(1/h*rep(1,h))
eps=0.1
theta$alpha_gh=matrix(c(1-eps,eps  ,eps  ,
                       eps  ,1-eps,eps  ,
                       eps  ,1-eps,1-eps,
                       1-eps,1-eps,eps  ,
                       eps  ,eps  ,eps   ),ncol=h,byrow=TRUE)
n=250
J=150
data=BinBlocRnd_LBM(n,J,theta)
BinBlocVisu_LBM(data$x, data$xrow,data$xcol)
res=BIKM1_LBM_Binary(data$x,8,5,4,init_choice='smallVBayes')
BinBlocVisu_LBM(data$x,res@model_max$z,res@model_max$v)
e=CARI(data$xrow,data$xcol,res@model_max$z,res@model_max$v)
plot(res,data)}
}
