% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-vec.R
\name{big_prodVec}
\alias{big_prodVec}
\title{Product with a vector}
\usage{
big_prodVec(
  X,
  y.col,
  ind.row = rows_along(X),
  ind.col = cols_along(X),
  center = NULL,
  scale = NULL,
  ncores = 1
)
}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{y.col}{A vector of same size as \code{ind.col}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{center}{Vector of same length of \code{ind.col} to subtract from columns of \code{X}.}

\item{scale}{Vector of same length of \code{ind.col} to divide from columns of \code{X}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
\eqn{X \cdot y}.
}
\description{
Product between a Filebacked Big Matrix and a vector.
}
\examples{
X <- big_attachExtdata()
n <- nrow(X)
m <- ncol(X)
y <- rnorm(m)

test <- big_prodVec(X, y)      # vector
true <- X[] \%*\% y  # one-column matrix
all.equal(test, as.numeric(true))

# subsetting
ind.row <- sample(n, n/2)
ind.col <- sample(m, m/2)

tryCatch(test2 <- big_prodVec(X, y, ind.row, ind.col),
         error = function(e) print(e))
# returns an error. You need to use the subset of y:
test2 <- big_prodVec(X, y[ind.col], ind.row, ind.col)
true2 <- X[ind.row, ind.col] \%*\% y[ind.col]
all.equal(test2, as.numeric(true2))

}
