% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/upload.r
\name{insert_upload_job}
\alias{insert_upload_job}
\title{Upload data.}
\usage{
insert_upload_job(project, dataset, table, values, billing = project)
}
\arguments{
\item{project}{project containing this table}

\item{dataset}{dataset containing this table}

\item{table}{name of table to insert values into}

\item{values}{data frame of data to upload}

\item{billing}{project ID to use for billing}
}
\description{
This sends all of the data inline in the HTTP request so is only suitable
for relatively small datasets.
}
\examples{
\dontrun{
list_datasets("193487687779")
list_tables("193487687779", "houston")
job <- insert_upload_job("193487687779", "houston", "mtcars", mtcars)
wait_for(job)
list_tables("193487687779", "houston")
delete_table("193487687779", "houston", "mtcars")
}
}
\seealso{
Google API documentation:
\url{https://developers.google.com/bigquery/loading-data-into-bigquery#loaddatapostrequest}

Other jobs: \code{\link{get_job}};
  \code{\link{insert_query_job}}; \code{\link{wait_for}}
}

