% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\docType{methods}
\name{apply,big.matrix-method}
\alias{apply,big.matrix-method}
\title{apply() for big.matrix objects}
\usage{
\S4method{apply}{big.matrix}(X, MARGIN, FUN, ..., simplify)
}
\arguments{
\item{X}{a big.matrix object.}

\item{MARGIN}{the margin. May be may only be 1 or 2, but otherwise 
conforming to what you would expect from \code{apply()}.}

\item{FUN}{the function to apply.}

\item{\dots}{other parameters to pass to the FUN parameter.}

\item{simplify}{see the base::apply documentation.}
}
\description{
\link{apply} for \code{\link[bigmemory]{big.matrix}} objects.
Note that the performance may be degraded (compared to \code{apply} with 
regular \R matrices) because of S4 overhead associated with extracting data 
from \code{big.matrix} objects.  This sort of limitation is unavoidable and 
would be the case (or even worse) with other "custom" data structures.  Of 
course, this would only be partically significant if you are applying over 
lengthy rows or columns.
}
\examples{
library(bigmemory)
options(bigmemory.typecast.warning=FALSE)
x <- big.matrix(5, 2, type="integer", init=0,
                dimnames=list(NULL, c("alpha", "beta")))
x[,] <- round(rnorm(10))
biganalytics::apply(x, 1, mean)
}
