% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{Table}
\alias{Table}
\title{Table Object}
\usage{
Table(tableId, projectId = bqr_get_global_project(),
  datasetId = bqr_get_global_dataset(), clustering = NULL,
  description = NULL, encryptionConfiguration = NULL,
  expirationTime = NULL, friendlyName = NULL, labels = NULL,
  materializedView = NULL, rangePartitioning = NULL,
  requirePartitionFilter = NULL, schema = NULL,
  timePartitioning = NULL, view = NULL)
}
\arguments{
\item{tableId}{tableId}

\item{projectId}{projectId}

\item{datasetId}{datasetId}

\item{clustering}{[Beta] Clustering specification for the table}

\item{description}{[Optional] A user-friendly description of this table}

\item{encryptionConfiguration}{Custom encryption configuration (e}

\item{expirationTime}{[Optional] The time when this table expires, in milliseconds since the epoch}

\item{friendlyName}{[Optional] A descriptive name for this table}

\item{labels}{The labels associated with this table - a named list of key = value}

\item{materializedView}{[Optional] Materialized view definition}

\item{rangePartitioning}{[TrustedTester] Range partitioning specification for this table}

\item{requirePartitionFilter}{[Beta] [Optional] If set to true, queries over this table require a partition filter that can be used for partition elimination to be specified}

\item{schema}{[Optional] Describes the schema of this table}

\item{timePartitioning}{Time-based partitioning specification for this table}

\item{view}{[Optional] The view definition}
}
\value{
Table object
}
\description{
Configure table objects as documented by 
the \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/tables}{Google docs for Table objects}
}
\details{
A table object to be used within \link{bqr_patch_table}
}
\seealso{
Other Table meta functions: \code{\link{bqr_copy_table}},
  \code{\link{bqr_create_table}},
  \code{\link{bqr_delete_table}},
  \code{\link{bqr_list_tables}},
  \code{\link{bqr_patch_table}},
  \code{\link{bqr_table_data}},
  \code{\link{bqr_table_meta}}
}
\concept{Table meta functions}
