% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.lbc.ls.R
\name{bfa.lbc.ls}
\alias{bfa.lbc.ls}
\title{Linear Function Bias-Corrected Estimators for BAR(p); p=1,2,...,6}
\usage{
bfa.lbc.ls(z, p)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}
}
\value{
\item{coef.lbc}{linear-bias-function-based bias-corrected least
squares estimates of the autoregressive coefficients}
}
\description{
This function performs bias correction on the least squares estimators of the
autoregressive coefficients in a BAR(p) model based on the assumption that
the bias of the least squares estimator is approximately linear as a function
of the parameter as described in Elbayoumi & Mostafa (2020).
}
\examples{
z <- bfa.tree.gen(127, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa.lbc.ls(z, p=1)
z <- bfa.tree.gen(127, 2, 1, 1, 0.5, 0.5, 0, 10, c(0.5, 0.3))
bfa.lbc.ls(z, p=2)
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2020). On the estimation bias
in bifurcating autoregressive models. \emph{Stat}, 1-16.
}
