% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_APEs.R
\name{get_APEs}
\alias{get_APEs}
\alias{apeff_bife}
\title{Compute average partial effects for binary choice models with fixed effects}
\usage{
get_APEs(
  object,
  n_pop = NULL,
  sampling_fe = c("independence", "unrestricted"),
  weak_exo = FALSE
)

apeff_bife(...)
}
\arguments{
\item{object}{an object of class \code{"bife"}.}

\item{n_pop}{unsigned integer indicating a finite population correction for the estimation of the 
covariance matrix of the average partial effects proposed by 
Cruz-Gonzalez, Fernández-Val, and Weidner (2017). The correction factor is computed as follows: 
\eqn{(n^{\ast} - n) / (n^{\ast} - 1)}{(n.pop - n) / (n.pop - 1)}, 
where \eqn{n^{\ast}}{n.pop} and \eqn{n}{n} are the size of the entire 
population and the full sample size. Default is \code{NULL}, which refers to a factor of one and 
is equal to an infinitely large population.}

\item{sampling_fe}{a string equal to \code{"independence"} or \code{"unrestricted"} which imposes 
sampling assumptions about the unobserved effects. \code{"independence"} imposes that all 
unobserved effects are mutually independent sequences. \code{"unrestricted"} does not impose any
sampling assumptions. Note that this option only affects the estimation of the covariance. 
Default is \code{"independence"}.}

\item{weak_exo}{logical indicating if some of the regressors are assumed to be weakly exogenous (e.g. 
predetermined). If object is returned by \code{\link{bias_corr}}, the option will be 
automatically set to \code{TRUE} if the choosen bandwidth parameter is larger than zero. 
Note that this option only affects the estimation of the covariance matrix. 
Default is \code{FALSE}, which assumes that all regressors are strictly exogenous.}

\item{...}{arguments passed to the deprecated function \code{\link{apeff_bife}}.}
}
\value{
The function \code{\link{get_APEs}} returns a named list of class \code{"bifeAPEs"}.
}
\description{
\code{\link{get_APEs}} is a post-estimation routine that can be used to estimate average partial 
effects with respect to all covariates in the model and the corresponding covariance matrix. The 
estimation of the covariance is based on a linear approximation (delta method). Note that 
the command automatically determines which of the regressors are continuous or binary.

\strong{Remark:} The routine currently does not allow to compute average partial effects based 
on functional forms like interactions and polynomials.

\strong{Note:} \code{\link{apeff_bife}} is deprecated and will be removed soon.
}
\examples{
\donttest{
# Load 'psid' dataset
library(bife)
dataset <- psid

# Fit a static logit model
mod <- bife(LFP ~ I(AGE^2) + log(INCH) + KID1 + KID2 + KID3 + factor(TIME) | ID, dataset)
summary(mod)

# Compute average partial effects
mod_ape <- get_APEs(mod)
summary(mod_ape)

# Apply analytical bias correction
mod_bc <- bias_corr(mod)
summary(mod_bc)

# Compute bias-corrected average partial effects
mod_ape_bc <- get_APEs(mod_bc)
summary(mod_ape_bc)
}
}
\references{
Cruz-Gonzalez, M., I. Fernández-Val, and M. Weidner. (2017). "Bias corrections for probit and 
logit models with two-way fixed effects". The Stata Journal, 17(3), 517-545.

Fernández-Val, I. (2009). "Fixed effects estimation of structural parameters and marginal 
effects in panel probit models". Journal of Econometrics 150(1), 71-85.

Fernández-Val, I. and M. Weidner (2018). "Fixed effects estimation of large-t panel data models". 
Annual Review of Economics, 10, 109-138.

Neyman, J. and E. L. Scott (1948). "Consistent estimates based on partially consistent 
observations". Econometrica, 16(1), 1-32.

Stammann, A., F. Heiss, and D. McFadden (2016). "Estimating Fixed Effects Logit Models with 
Large Panel Data". Working paper.
}
\seealso{
\code{\link{bias_corr}}, \code{\link{bife}}
}
