% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{FlattenList}
\alias{FlattenList}
\title{Flatten List}
\usage{
FlattenList(li, rm.duplicated = TRUE, unname.li = TRUE,
  rm.empty = TRUE)
}
\arguments{
\item{li}{list to flatten}

\item{rm.duplicated}{logical, indicating whether or not to remove duplicated lists, Default: TRUE}

\item{unname.li}{logical, indicating whether or not to unname lists, Default: TRUE}

\item{rm.empty}{logical, indicating whether or not to remove empty lists, Default: TRUE}
}
\description{
flatten a nested list into a single list
}
\examples{
li <- list(LETTERS[1:3],
           list(letters[1:3],
                list(LETTERS[4:6])),
           DEF = letters[4:6],
           LETTERS[1:3],
           list() # Emtpy list
)
print(li)
# [[1]]
# [1] "A" "B" "C"
#
# [[2]]
# [[2]][[1]]
# [1] "a" "b" "c"
#
# [[2]][[2]]
# [[2]][[2]][[1]]
# [1] "D" "E" "F"
#
#
#
# $DEF
# [1] "d" "e" "f"
#
# [[4]]
# [1] "A" "B" "C"
#
# [[5]]
# list()
FlattenList(li)
# [[1]]
# [1] "A" "B" "C"
#
# [[2]]
# [1] "a" "b" "c"
#
# [[3]]
# [1] "D" "E" "F"
#
# [[4]]
# [1] "d" "e" "f"
}
