% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-r-sq-nb.R
\name{RSqNB}
\alias{RSqNB}
\title{Estimate Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
RSqNB(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{R^{2}} and \eqn{\bar{R}^{2}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{R^{2}} and \eqn{\bar{R}^{2}}.}
\item{est}{Vector of estimated
\eqn{R^{2}} and \eqn{\bar{R}^{2}}.}
\item{fun}{Function used ("RSqMC").}
}
}
\description{
Estimate Multiple Correlation Coefficients
(R-Squared and Adjusted R-Squared)
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
R-squared (\eqn{R^{2}}) and
adjusted R-squared (\eqn{\bar{R}^{2}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{R^{2}} and \eqn{\bar{R}^{2}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of sample covariances
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for standardized regression slopes
rsq <- RSqNB(nb)
# Methods --------------------------------------------------------
print(rsq)
summary(rsq)
coef(rsq)
vcov(rsq)
confint(rsq, level = 0.95)
}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{.CI}()},
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{rsq}
