% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-delta-r-sq-nb.R
\name{DeltaRSqNB}
\alias{DeltaRSqNB}
\title{Estimate Improvement in R-Squared
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
DeltaRSqNB(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{\Delta R^{2}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{\Delta R^{2}}.}
\item{est}{Vector of estimated
\eqn{\Delta R^{2}}.}
\item{fun}{Function used ("DeltaRSqMC").}
}
}
\description{
Estimate Improvement in R-Squared
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of improvement in R-squared
(\eqn{\Delta R^{2}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{\Delta R^{2}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of sample covariances
# (use a large R, for example, R = 5000 for actual research)
nb <- NB(object, R = 50)
# Generate confidence intervals for improvement in R-squared
deltarsq <- DeltaRSqNB(nb)
# Methods --------------------------------------------------------
print(deltarsq)
summary(deltarsq)
coef(deltarsq)
vcov(deltarsq)
confint(deltarsq, level = 0.95)
}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{.CI}()},
\code{\link{BetaNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{PCorNB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{deltarsq}
