% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqR.R
\name{seqR}
\alias{seqR}
\title{seq with a range argument}
\usage{
seqR(range, from = NA, to = NA, extend = 0, warn = TRUE, ...)
}
\arguments{
\item{range}{vector with 2 values (1st taken as \code{from}, 2nd as \code{to}) 
or more (the result is then always ascending).}

\item{from}{start value of sequence. DEFAULT: NA (determined from range)}

\item{to}{end value of sequence. DEFAULT: NA (determined from range)}

\item{extend}{Factor \emph{f} passed to \code{\link{extendrange}}. DEFAULT: 0}

\item{warn}{Logical: warn about non-numeric classes? DEFAULT: TRUE}

\item{\dots}{further arguments passed to \code{\link{seq}}.}
}
\value{
Numeric vector.
}
\description{
sequence given by range or vector of values.
}
\examples{

seqR(range=c(12,6), by=-2)
m <- c(41, 12, 38, 29, 50, 39, 22)
seqR(m, len=6)
# Takes min and max of range if the vector has more than two elements.

seqR(range=c(12,6), by=-2, extend=0.1)
# internaly calls extendrange with f=extend

}
\seealso{
\code{\link{seq}}, \code{\link{range}},
         \url{https://web.archive.org/web/20190107005108/https://r.789695.n4.nabble.com/seq-range-argument-td4684627.html}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Feb 2014
}
\keyword{datagen}
