% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na9.R
\name{na9}
\alias{na9}
\title{Prepend spaces before na.strings}
\usage{
na9(nspace = 5, base = c(-9999, -999, -9.99, -9.999), sep = c(",", "."),
  digits = 0:4, more = NULL, ...)
}
\arguments{
\item{nspace}{number of spaces prepended. DEFAULT: 5}

\item{base}{Numeric: basic na.string numbers}

\item{sep}{Separator string (comma or decimal point or both). DEFAULT: c(",",".")}

\item{digits}{Number(s) of zeros to be appended. DEFAULT: 0:4}

\item{more}{More structures added to base, like "NA", "--". digits and sep is not added to this! DEFAULT: NULL}

\item{\dots}{Arguments passed to nothing currently}
}
\value{
Character strings
}
\description{
Returns a number of useful character strings with varying amount of spaces prepended. 
It can be used as \code{na.strings=na9()} in \code{\link{read.table}}.
}
\examples{

na9()
na9(nspace=0, sep=".")
na9(nspace=0, sep=".", more=c(NA,"-"))

}
\seealso{
\code{\link{paste}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2016
}
\keyword{IO}
\keyword{file}
