% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFile.R
\name{checkFile}
\alias{checkFile}
\title{check file existance}
\usage{
checkFile(file, fun = stop, trace = TRUE, ...)
}
\arguments{
\item{file}{Filename(s) as character string to be checked for existence.}

\item{fun}{One of the functions \code{\link{stop}}, \code{\link{warning}}, or \code{\link{message}}. DEFAULT: stop}

\item{trace}{Logical: Add function call stack to the message? DEFAULT: TRUE
WARNING: in \link{do.call} settings with large objects,
tracing may take a lot of computing time.}

\item{\dots}{Further arguments passed to \code{fun}}
}
\value{
TRUE/FALSE, invisibly
}
\description{
check whether a file exists and give a useful error/warning/message
}
\examples{
is.error( checkFile("FileThatDoesntExist.txt") )
checkFile("FileThatDoesntExist.txt", fun=warning)
checkFile("FileThatDoesntExist.txt", fun=message)
is.error( checkFile("FileThatDoesntExist.txt", fun=MyWarn) ) # nonexisting function

\dontrun{## Excluded from CRAN checks because of file creation
# Vectorized:
file.create("DummyFile2.txt")
checkFile(paste0("DummyFile",1:3,".txt"), fun=message)
checkFile(paste0("DummyFile",1:3,".txt") )
file.remove("DummyFile2.txt")
}

\dontrun{## Excluded from CRAN checks because of intentional errors
compareFiles("dummy.nonexist", "dummy2.nonexist")
checkFile("dummy.nonexist")

dingo <- function(k="brute.nonexist") checkFile(k)
dingo()
dingo("dummy.nonexist")

upper <- function(h) dingo(c(h, "dumbo.nonexist"))
upper("dumbo2.nonexist")
}

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2016
}
\seealso{
\code{\link{file.exists}}
}
\keyword{file}

