% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_naloxone.R
\name{est_naloxone}
\alias{est_naloxone}
\title{Run Bayesian estimation of naloxone number under-reporting}
\usage{
est_naloxone(
  d,
  psi_vec = c(0.7, 0.2, 0.1),
  max_delays = 3,
  delay_alpha = 2,
  delay_beta = 1,
  run_estimation = TRUE,
  rw_type = 1,
  chains = 4,
  iter = 2000,
  seed = 42,
  adapt_delta = 0.85,
  ...
)
}
\arguments{
\item{d}{data frame with format
\describe{
\item{regions}{unique id for region}
\item{times}{time in months}
\item{Orders}{Kits ordered}
\item{Reported_Used}{Kits reported as used}
\item{Reported_Distributed}{Kits reported as distributed}
\item{region_name}{Optional label for region}
}}

\item{psi_vec}{reporting delay distribution}

\item{max_delays}{maximum delay from kit ordered to kit distributed}

\item{delay_alpha}{shape parameter for order to distributed delay
distribution}

\item{delay_beta}{shape parameter for order to distributed delay distribution}

\item{run_estimation}{if \code{TRUE} will sample from posterior otherwise will
sample from prior only}

\item{rw_type}{\code{1} - random walk of order one. \code{2} - random walk of order 2.}

\item{chains}{A positive integer specifying the number of Markov chains.
The default is 4.}

\item{iter}{A positive integer specifying the number of iterations
for each chain (including warmup). The default is 2000.}

\item{seed}{Seed for random number generation}

\item{adapt_delta}{(double, between 0 and 1, defaults to 0.8)}

\item{...}{other parameters to pass to \link[rstan:stanmodel-method-sampling]{rstan::sampling}}
}
\value{
An S4 stanfit class object containing the fitted model
}
\description{
Samples from Bayesian model using input from data frame
}
\examples{
\dontrun{
library(rstan)
library(bayesplot)

rstan_options(auto_write = TRUE)
options(mc.cores = parallel::detectCores(logical = FALSE))

d <- generate_model_data()
fit <- est_naloxone(d, iter = 100, chains = 1)
mcmc_pairs(fit,
  pars = c("sigma", "mu0"),
  off_diag_args = list(size = 1, alpha = 0.5)
)
}
}
\seealso{
Other inference: 
\code{\link{est_naloxone_vec}()}
}
\concept{inference}
