% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sys_details.R
\name{get_sys_details}
\alias{get_sys_details}
\title{General system information}
\usage{
get_sys_details(sys_info = TRUE, platform_info = TRUE, r_version = TRUE,
  ram = TRUE, cpu = TRUE, byte_compiler = TRUE, linear_algebra = TRUE,
  locale = TRUE, installed_packages = TRUE, machine = TRUE)
}
\arguments{
\item{sys_info}{Default \code{TRUE}.}

\item{platform_info}{Default \code{TRUE}.}

\item{r_version}{Default \code{TRUE}.}

\item{ram}{Default \code{TRUE}.}

\item{cpu}{Default \code{TRUE}.}

\item{byte_compiler}{Default \code{TRUE}.}

\item{linear_algebra}{Default \code{TRUE}.}

\item{locale}{Default \code{TRUE}}

\item{installed_packages}{Default \code{TRUE}.}

\item{machine}{Default \code{TRUE}}
}
\value{
A list
}
\description{
The \code{get_sys_info} returns general system level information as a list. The 
function parameters control the information to upload. If a parameter is set to
\code{FALSE}, an \code{NA} is uploaded instead. Each element of the list
is contains the output from: 
\itemize{
\item \code{Sys.info()};
\item \code{get_platform_info()};
\item \code{get_r_version()};
\item \code{get_ram()};
\item \code{get_cpu()};
\item \code{get_byte_compiler()};
\item \code{get_linear_algebra()};
\item \code{Sys.getlocale()}
\item \code{installed.packages()};
\item \code{.Machine}
\item The package version number;
\item Unique ID - used to extract results;
\item The current date.
}
}
\examples{
## Returns all details about your machine
get_sys_details()
}
