#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_bs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_bs : public prob_grad {
private:
    int SIZE;
    vector_d Y;
    vector_d SIGY;
    double B;
    double D;
    double DELTA;
    int PRIORSIG;
public:
    model_bs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_bs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_bs_namespace::model_bs";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "D", "double", context__.to_vec());
        D = double(0);
        vals_r__ = context__.vals_r("D");
        pos__ = 0;
        D = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"D",D,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nphi", "SIZE", SIZE);
        num_params_r__ += SIZE;
    }

    ~model_bs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        // generate_declaration b0
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec());
        // generate_declaration omega
        double omega(0);
        omega = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        if (!(context__.contains_r("nphi")))
            throw std::runtime_error("variable nphi missing");
        vals_r__ = context__.vals_r("nphi");
        pos__ = 0U;
        validate_non_negative_index("nphi", "SIZE", SIZE);
        context__.validate_dims("initialization", "nphi", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nphi
        vector_d nphi(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nphi(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nphi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nphi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        T__ omega;
        (void) omega;  // dummy to suppress unused var warning
        if (jacobian__)
            omega = in__.scalar_lb_constrain(0,lp__);
        else
            omega = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nphi;
        (void) nphi;  // dummy to suppress unused var warning
        if (jacobian__)
            nphi = in__.vector_constrain(SIZE,lp__);
        else
            nphi = in__.vector_constrain(SIZE);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("phi", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  phi(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) phi;  // dummy to suppress unused var warning

        stan::math::initialize(phi, DUMMY_VAR__);
        stan::math::fill(phi,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 35;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 36;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 38;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 42;
            stan::math::assign(phi, multiply(nphi,omega));
            current_statement_begin__ = 43;
            stan::math::assign(mu, add(b0,phi));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(phi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: phi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(mu(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(B)));
            current_statement_begin__ = 48;
            lp_accum__.add(normal_log<propto__>(nphi, 0, 1));
            current_statement_begin__ = 49;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 50;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 52;
            if (as_bool(logical_eq(0,D))) {

                current_statement_begin__ = 54;
                lp_accum__.add(-(log(omega)));
            } else {

                current_statement_begin__ = 57;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(D)));
            }
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b0");
        names__.push_back("omega");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("nphi");
        names__.push_back("vs");
        names__.push_back("phi");
        names__.push_back("mu");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_bs_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double b0 = in__.scalar_constrain();
        double omega = in__.scalar_lb_constrain(0);
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        vector_d nphi = in__.vector_constrain(SIZE);
        vars__.push_back(b0);
        vars__.push_back(omega);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nphi[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("phi", "SIZE", SIZE);
        vector_d phi(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) phi;  // dummy to suppress unused var warning

        stan::math::initialize(phi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phi,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 35;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 36;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 38;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 42;
            stan::math::assign(phi, multiply(nphi,omega));
            current_statement_begin__ = 43;
            stan::math::assign(mu, add(b0,phi));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 65;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 66;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_bs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nphi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nphi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_ds_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ds : public prob_grad {
private:
    int SIZE;
    int NX;
    vector_d Y;
    vector_d SIGY;
    matrix_d X;
    double B;
    double D;
    double DELTA;
    int PRIORSIG;
public:
    model_ds(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ds(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ds_namespace::model_ds";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "D", "double", context__.to_vec());
        D = double(0);
        vals_r__ = context__.vals_r("D");
        pos__ = 0;
        D = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"D",D,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nomega", "NX", NX);
        num_params_r__ += NX;
    }

    ~model_ds() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        // generate_declaration b0
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec());
        // generate_declaration omega
        double omega(0);
        omega = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        if (!(context__.contains_r("nomega")))
            throw std::runtime_error("variable nomega missing");
        vals_r__ = context__.vals_r("nomega");
        pos__ = 0U;
        validate_non_negative_index("nomega", "NX", NX);
        context__.validate_dims("initialization", "nomega", "vector_d", context__.to_vec(NX));
        // generate_declaration nomega
        vector_d nomega(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            nomega(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nomega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nomega: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        T__ omega;
        (void) omega;  // dummy to suppress unused var warning
        if (jacobian__)
            omega = in__.scalar_lb_constrain(0,lp__);
        else
            omega = in__.scalar_lb_constrain(0);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nomega;
        (void) nomega;  // dummy to suppress unused var warning
        if (jacobian__)
            nomega = in__.vector_constrain(NX,lp__);
        else
            nomega = in__.vector_constrain(NX);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("bgamma", "NX", NX);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        (void) bgamma;  // dummy to suppress unused var warning

        stan::math::initialize(bgamma, DUMMY_VAR__);
        stan::math::fill(bgamma,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 37;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 38;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 40;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 43;
            stan::math::assign(bgamma, multiply(nomega,omega));
            current_statement_begin__ = 44;
            stan::math::assign(mu, add(b0,multiply(X,bgamma)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < NX; ++i0__) {
            if (stan::math::is_uninitialized(bgamma(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: bgamma" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(mu(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(B)));
            current_statement_begin__ = 50;
            lp_accum__.add(normal_log<propto__>(nomega, 0, 1));
            current_statement_begin__ = 51;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 52;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 54;
            if (as_bool(logical_eq(0,D))) {

                current_statement_begin__ = 56;
                lp_accum__.add(-(log(omega)));
            } else {

                current_statement_begin__ = 59;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(D)));
            }
            current_statement_begin__ = 62;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b0");
        names__.push_back("omega");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("nomega");
        names__.push_back("vs");
        names__.push_back("bgamma");
        names__.push_back("mu");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ds_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double b0 = in__.scalar_constrain();
        double omega = in__.scalar_lb_constrain(0);
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        vector_d nomega = in__.vector_constrain(NX);
        vars__.push_back(b0);
        vars__.push_back(omega);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(nomega[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("bgamma", "NX", NX);
        vector_d bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        (void) bgamma;  // dummy to suppress unused var warning

        stan::math::initialize(bgamma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bgamma,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 37;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 38;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 40;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 43;
            stan::math::assign(bgamma, multiply(nomega,omega));
            current_statement_begin__ = 44;
            stan::math::assign(mu, add(b0,multiply(X,bgamma)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(bgamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 67;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 68;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ds";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nomega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nomega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_eds_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_eds : public prob_grad {
private:
    int SIZE;
    int NX;
    int NTAU;
    vector_d Y;
    vector_d SIGY;
    matrix_d X;
    vector<int> TAUINX;
    double B;
    double D;
    double DELTA;
    int PRIORSIG;
public:
    model_eds(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_eds(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_eds_namespace::model_eds";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NTAU", "int", context__.to_vec());
        NTAU = int(0);
        vals_i__ = context__.vals_i("NTAU");
        pos__ = 0;
        NTAU = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        validate_non_negative_index("TAUINX", "NX", NX);
        context__.validate_dims("data initialization", "TAUINX", "int", context__.to_vec(NX));
        validate_non_negative_index("TAUINX", "NX", NX);
        TAUINX = std::vector<int>(NX,int(0));
        vals_i__ = context__.vals_i("TAUINX");
        pos__ = 0;
        size_t TAUINX_limit_0__ = NX;
        for (size_t i_0__ = 0; i_0__ < TAUINX_limit_0__; ++i_0__) {
            TAUINX[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "D", "double", context__.to_vec());
        D = double(0);
        vals_r__ = context__.vals_r("D");
        pos__ = 0;
        D = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"NTAU",NTAU,0);
        for (int k0__ = 0; k0__ < NX; ++k0__) {
            check_greater_or_equal(function__,"TAUINX[k0__]",TAUINX[k0__],0);
        }
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"D",D,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        validate_non_negative_index("omega", "NTAU", NTAU);
        num_params_r__ += NTAU;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nomega", "NX", NX);
        num_params_r__ += NX;
    }

    ~model_eds() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        // generate_declaration b0
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        validate_non_negative_index("omega", "NTAU", NTAU);
        context__.validate_dims("initialization", "omega", "double", context__.to_vec(NTAU));
        // generate_declaration omega
        std::vector<double> omega(NTAU,double(0));
        for (int i0__ = 0U; i0__ < NTAU; ++i0__)
            omega[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < NTAU; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,omega[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        if (!(context__.contains_r("nomega")))
            throw std::runtime_error("variable nomega missing");
        vals_r__ = context__.vals_r("nomega");
        pos__ = 0U;
        validate_non_negative_index("nomega", "NX", NX);
        context__.validate_dims("initialization", "nomega", "vector_d", context__.to_vec(NX));
        // generate_declaration nomega
        vector_d nomega(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            nomega(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nomega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nomega: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        vector<T__> omega;
        size_t dim_omega_0__ = NTAU;
        omega.reserve(dim_omega_0__);
        for (size_t k_0__ = 0; k_0__ < dim_omega_0__; ++k_0__) {
            if (jacobian__)
                omega.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                omega.push_back(in__.scalar_lb_constrain(0));
        }

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nomega;
        (void) nomega;  // dummy to suppress unused var warning
        if (jacobian__)
            nomega = in__.vector_constrain(NX,lp__);
        else
            nomega = in__.vector_constrain(NX);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("bgamma", "NX", NX);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        (void) bgamma;  // dummy to suppress unused var warning

        stan::math::initialize(bgamma, DUMMY_VAR__);
        stan::math::fill(bgamma,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 43;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 44;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 46;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 49;
            for (int i = 1; i <= NX; ++i) {

                current_statement_begin__ = 50;
                stan::math::assign(get_base1_lhs(bgamma,i,"bgamma",1), (get_base1(omega,get_base1(TAUINX,i,"TAUINX",1),"omega",1) * get_base1(nomega,i,"nomega",1)));
            }
            current_statement_begin__ = 53;
            stan::math::assign(mu, add(b0,multiply(X,bgamma)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < NX; ++i0__) {
            if (stan::math::is_uninitialized(bgamma(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: bgamma" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(mu(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 57;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(B)));
            current_statement_begin__ = 58;
            lp_accum__.add(normal_log<propto__>(nomega, 0, 1));
            current_statement_begin__ = 59;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 62;
            if (as_bool(logical_eq(0,D))) {

                current_statement_begin__ = 64;
                for (int i = 1; i <= NTAU; ++i) {

                    current_statement_begin__ = 65;
                    lp_accum__.add(-(log(get_base1(omega,i,"omega",1))));
                }
            } else {

                current_statement_begin__ = 69;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(D)));
            }
            current_statement_begin__ = 72;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b0");
        names__.push_back("omega");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("nomega");
        names__.push_back("vs");
        names__.push_back("bgamma");
        names__.push_back("mu");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NTAU);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_eds_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double b0 = in__.scalar_constrain();
        vector<double> omega;
        size_t dim_omega_0__ = NTAU;
        for (size_t k_0__ = 0; k_0__ < dim_omega_0__; ++k_0__) {
            omega.push_back(in__.scalar_lb_constrain(0));
        }
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        vector_d nomega = in__.vector_constrain(NX);
        vars__.push_back(b0);
        for (int k_0__ = 0; k_0__ < NTAU; ++k_0__) {
            vars__.push_back(omega[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(nomega[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("bgamma", "NX", NX);
        vector_d bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        (void) bgamma;  // dummy to suppress unused var warning

        stan::math::initialize(bgamma, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(bgamma,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 43;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 44;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 46;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 49;
            for (int i = 1; i <= NX; ++i) {

                current_statement_begin__ = 50;
                stan::math::assign(get_base1_lhs(bgamma,i,"bgamma",1), (get_base1(omega,get_base1(TAUINX,i,"TAUINX",1),"omega",1) * get_base1(nomega,i,"nomega",1)));
            }
            current_statement_begin__ = 53;
            stan::math::assign(mu, add(b0,multiply(X,bgamma)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(bgamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 77;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 78;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_eds";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NTAU; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nomega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NTAU; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "omega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nomega" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_fs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_fs : public prob_grad {
private:
    int SIZE;
    vector_d Y;
    vector_d SIGY;
    double B;
    double DELTA;
    int PRIORSIG;
public:
    model_fs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_fs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_fs_namespace::model_fs";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        validate_non_negative_index("mu", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
    }

    ~model_fs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        validate_non_negative_index("mu", "SIZE", SIZE);
        context__.validate_dims("initialization", "mu", "vector_d", context__.to_vec(SIZE));
        // generate_declaration mu
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            mu(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.vector_constrain(SIZE,lp__);
        else
            mu = in__.vector_constrain(SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);


        try {
            current_statement_begin__ = 27;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 28;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 30;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 35;
            lp_accum__.add(normal_log<propto__>(mu, 0, sqrt(B)));
            current_statement_begin__ = 36;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 37;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 38;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("vs");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_fs_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu = in__.vector_constrain(SIZE);
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);


        try {
            current_statement_begin__ = 27;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 28;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 30;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 43;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 44;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_fs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_nse_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_nse : public prob_grad {
private:
    int SIZE;
    vector_d Y;
    vector_d SIGY;
    double B;
    double DELTA;
    int PRIORSIG;
public:
    model_nse(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_nse(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_nse_namespace::model_nse";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
    }

    ~model_nse() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("tau")))
            throw std::runtime_error("variable tau missing");
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        context__.validate_dims("initialization", "tau", "double", context__.to_vec());
        // generate_declaration tau
        double tau(0);
        tau = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(tau);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable tau: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ tau;
        (void) tau;  // dummy to suppress unused var warning
        if (jacobian__)
            tau = in__.scalar_constrain(lp__);
        else
            tau = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);


        try {
            current_statement_begin__ = 27;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 28;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 30;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 35;
            lp_accum__.add(normal_log<propto__>(tau, 0, sqrt(B)));
            current_statement_begin__ = 36;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 37;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 38;
            lp_accum__.add(normal_log<propto__>(Y, tau, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("tau");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("vs");
        names__.push_back("mu");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_nse_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double tau = in__.scalar_constrain();
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        vars__.push_back(tau);
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);


        try {
            current_statement_begin__ = 27;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 28;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 30;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("mu", "SIZE", SIZE);
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 45;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 46;
                stan::math::assign(get_base1_lhs(mu,i,"mu",1), tau);
            }
            current_statement_begin__ = 49;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 50;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_nse";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "tau";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_sr_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_sr : public prob_grad {
private:
    int SIZE;
    int NX;
    vector_d Y;
    vector_d SIGY;
    matrix_d X;
    double B;
    double C;
    double DELTA;
    int PRIORSIG;
public:
    model_sr(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_sr(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_sr_namespace::model_sr";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "C", "double", context__.to_vec());
        C = double(0);
        vals_r__ = context__.vals_r("C");
        pos__ = 0;
        C = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"C",C,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        validate_non_negative_index("bgamma", "NX", NX);
        num_params_r__ += NX;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
    }

    ~model_sr() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        // generate_declaration b0
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("bgamma")))
            throw std::runtime_error("variable bgamma missing");
        vals_r__ = context__.vals_r("bgamma");
        pos__ = 0U;
        validate_non_negative_index("bgamma", "NX", NX);
        context__.validate_dims("initialization", "bgamma", "vector_d", context__.to_vec(NX));
        // generate_declaration bgamma
        vector_d bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            bgamma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(bgamma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable bgamma: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,1>  bgamma;
        (void) bgamma;  // dummy to suppress unused var warning
        if (jacobian__)
            bgamma = in__.vector_constrain(NX,lp__);
        else
            bgamma = in__.vector_constrain(NX);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 35;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 36;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 38;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 41;
            stan::math::assign(mu, add(b0,multiply(X,bgamma)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(mu(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 45;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(B)));
            current_statement_begin__ = 46;
            lp_accum__.add(normal_log<propto__>(bgamma, 0, sqrt(C)));
            current_statement_begin__ = 47;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 48;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 49;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("b0");
        names__.push_back("bgamma");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("vs");
        names__.push_back("mu");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_sr_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double b0 = in__.scalar_constrain();
        vector_d bgamma = in__.vector_constrain(NX);
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        vars__.push_back(b0);
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(bgamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);


        try {
            current_statement_begin__ = 35;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 36;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 38;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 41;
            stan::math::assign(mu, add(b0,multiply(X,bgamma)));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 54;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 55;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_sr";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.15.0

#include <stan/model/model_header.hpp>

namespace model_srs_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_srs : public prob_grad {
private:
    int SIZE;
    int NX;
    vector_d Y;
    vector_d SIGY;
    matrix_d X;
    double B;
    double C;
    double D;
    double DELTA;
    int PRIORSIG;
public:
    model_srs(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_srs(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_srs_namespace::model_srs";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        context__.validate_dims("data initialization", "SIZE", "int", context__.to_vec());
        SIZE = int(0);
        vals_i__ = context__.vals_i("SIZE");
        pos__ = 0;
        SIZE = vals_i__[pos__++];
        context__.validate_dims("data initialization", "NX", "int", context__.to_vec());
        NX = int(0);
        vals_i__ = context__.vals_i("NX");
        pos__ = 0;
        NX = vals_i__[pos__++];
        validate_non_negative_index("Y", "SIZE", SIZE);
        context__.validate_dims("data initialization", "Y", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("Y", "SIZE", SIZE);
        Y = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("Y");
        pos__ = 0;
        size_t Y_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < Y_i_vec_lim__; ++i_vec__) {
            Y[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        context__.validate_dims("data initialization", "SIGY", "vector_d", context__.to_vec(SIZE));
        validate_non_negative_index("SIGY", "SIZE", SIZE);
        SIGY = vector_d(static_cast<Eigen::VectorXd::Index>(SIZE));
        vals_r__ = context__.vals_r("SIGY");
        pos__ = 0;
        size_t SIGY_i_vec_lim__ = SIZE;
        for (size_t i_vec__ = 0; i_vec__ < SIGY_i_vec_lim__; ++i_vec__) {
            SIGY[i_vec__] = vals_r__[pos__++];
        }
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(SIZE,NX));
        validate_non_negative_index("X", "SIZE", SIZE);
        validate_non_negative_index("X", "NX", NX);
        X = matrix_d(static_cast<Eigen::VectorXd::Index>(SIZE),static_cast<Eigen::VectorXd::Index>(NX));
        vals_r__ = context__.vals_r("X");
        pos__ = 0;
        size_t X_m_mat_lim__ = SIZE;
        size_t X_n_mat_lim__ = NX;
        for (size_t n_mat__ = 0; n_mat__ < X_n_mat_lim__; ++n_mat__) {
            for (size_t m_mat__ = 0; m_mat__ < X_m_mat_lim__; ++m_mat__) {
                X(m_mat__,n_mat__) = vals_r__[pos__++];
            }
        }
        context__.validate_dims("data initialization", "B", "double", context__.to_vec());
        B = double(0);
        vals_r__ = context__.vals_r("B");
        pos__ = 0;
        B = vals_r__[pos__++];
        context__.validate_dims("data initialization", "C", "double", context__.to_vec());
        C = double(0);
        vals_r__ = context__.vals_r("C");
        pos__ = 0;
        C = vals_r__[pos__++];
        context__.validate_dims("data initialization", "D", "double", context__.to_vec());
        D = double(0);
        vals_r__ = context__.vals_r("D");
        pos__ = 0;
        D = vals_r__[pos__++];
        context__.validate_dims("data initialization", "DELTA", "double", context__.to_vec());
        DELTA = double(0);
        vals_r__ = context__.vals_r("DELTA");
        pos__ = 0;
        DELTA = vals_r__[pos__++];
        context__.validate_dims("data initialization", "PRIORSIG", "int", context__.to_vec());
        PRIORSIG = int(0);
        vals_i__ = context__.vals_i("PRIORSIG");
        pos__ = 0;
        PRIORSIG = vals_i__[pos__++];

        // validate, data variables
        check_greater_or_equal(function__,"SIZE",SIZE,0);
        check_greater_or_equal(function__,"NX",NX,0);
        check_greater_or_equal(function__,"B",B,0);
        check_greater_or_equal(function__,"C",C,0);
        check_greater_or_equal(function__,"D",D,0);
        check_greater_or_equal(function__,"DELTA",DELTA,0);
        check_greater_or_equal(function__,"PRIORSIG",PRIORSIG,0);
        check_less_or_equal(function__,"PRIORSIG",PRIORSIG,1);
        // initialize data variables

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // validate, set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        validate_non_negative_index("bgamma", "NX", NX);
        num_params_r__ += NX;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        num_params_r__ += SIZE;
        validate_non_negative_index("nphi", "SIZE", SIZE);
        num_params_r__ += SIZE;
    }

    ~model_srs() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("omega")))
            throw std::runtime_error("variable omega missing");
        vals_r__ = context__.vals_r("omega");
        pos__ = 0U;
        context__.validate_dims("initialization", "omega", "double", context__.to_vec());
        // generate_declaration omega
        double omega(0);
        omega = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,omega);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable omega: ") + e.what());
        }

        if (!(context__.contains_r("b0")))
            throw std::runtime_error("variable b0 missing");
        vals_r__ = context__.vals_r("b0");
        pos__ = 0U;
        context__.validate_dims("initialization", "b0", "double", context__.to_vec());
        // generate_declaration b0
        double b0(0);
        b0 = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(b0);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable b0: ") + e.what());
        }

        if (!(context__.contains_r("bgamma")))
            throw std::runtime_error("variable bgamma missing");
        vals_r__ = context__.vals_r("bgamma");
        pos__ = 0U;
        validate_non_negative_index("bgamma", "NX", NX);
        context__.validate_dims("initialization", "bgamma", "vector_d", context__.to_vec(NX));
        // generate_declaration bgamma
        vector_d bgamma(static_cast<Eigen::VectorXd::Index>(NX));
        for (int j1__ = 0U; j1__ < NX; ++j1__)
            bgamma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(bgamma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable bgamma: ") + e.what());
        }

        if (!(context__.contains_r("uvs")))
            throw std::runtime_error("variable uvs missing");
        vals_r__ = context__.vals_r("uvs");
        pos__ = 0U;
        validate_non_negative_index("uvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "uvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration uvs
        vector_d uvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            uvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lub_unconstrain(0,1,uvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable uvs: ") + e.what());
        }

        if (!(context__.contains_r("nvs")))
            throw std::runtime_error("variable nvs missing");
        vals_r__ = context__.vals_r("nvs");
        pos__ = 0U;
        validate_non_negative_index("nvs", "SIZE", SIZE);
        context__.validate_dims("initialization", "nvs", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nvs
        vector_d nvs(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nvs(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nvs);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nvs: ") + e.what());
        }

        if (!(context__.contains_r("nphi")))
            throw std::runtime_error("variable nphi missing");
        vals_r__ = context__.vals_r("nphi");
        pos__ = 0U;
        validate_non_negative_index("nphi", "SIZE", SIZE);
        context__.validate_dims("initialization", "nphi", "vector_d", context__.to_vec(SIZE));
        // generate_declaration nphi
        vector_d nphi(static_cast<Eigen::VectorXd::Index>(SIZE));
        for (int j1__ = 0U; j1__ < SIZE; ++j1__)
            nphi(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(nphi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable nphi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ omega;
        (void) omega;  // dummy to suppress unused var warning
        if (jacobian__)
            omega = in__.scalar_lb_constrain(0,lp__);
        else
            omega = in__.scalar_lb_constrain(0);

        T__ b0;
        (void) b0;  // dummy to suppress unused var warning
        if (jacobian__)
            b0 = in__.scalar_constrain(lp__);
        else
            b0 = in__.scalar_constrain();

        Eigen::Matrix<T__,Eigen::Dynamic,1>  bgamma;
        (void) bgamma;  // dummy to suppress unused var warning
        if (jacobian__)
            bgamma = in__.vector_constrain(NX,lp__);
        else
            bgamma = in__.vector_constrain(NX);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  uvs;
        (void) uvs;  // dummy to suppress unused var warning
        if (jacobian__)
            uvs = in__.vector_lub_constrain(0,1,SIZE,lp__);
        else
            uvs = in__.vector_lub_constrain(0,1,SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nvs;
        (void) nvs;  // dummy to suppress unused var warning
        if (jacobian__)
            nvs = in__.vector_constrain(SIZE,lp__);
        else
            nvs = in__.vector_constrain(SIZE);

        Eigen::Matrix<T__,Eigen::Dynamic,1>  nphi;
        (void) nphi;  // dummy to suppress unused var warning
        if (jacobian__)
            nphi = in__.vector_constrain(SIZE,lp__);
        else
            nphi = in__.vector_constrain(SIZE);


        // transformed parameters
        validate_non_negative_index("vs", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, DUMMY_VAR__);
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, DUMMY_VAR__);
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("phi", "SIZE", SIZE);
        Eigen::Matrix<T__,Eigen::Dynamic,1>  phi(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) phi;  // dummy to suppress unused var warning

        stan::math::initialize(phi, DUMMY_VAR__);
        stan::math::fill(phi,DUMMY_VAR__);


        try {
            current_statement_begin__ = 39;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 40;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 42;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 45;
            stan::math::assign(phi, multiply(nphi,omega));
            current_statement_begin__ = 46;
            stan::math::assign(mu, add(add(b0,multiply(X,bgamma)),phi));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(vs(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: vs" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(mu(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: mu" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < SIZE; ++i0__) {
            if (stan::math::is_uninitialized(phi(i0__))) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: phi" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning
        check_greater_or_equal(function__,"vs",vs,0);

        // model body
        try {

            current_statement_begin__ = 51;
            lp_accum__.add(normal_log<propto__>(b0, 0, sqrt(B)));
            current_statement_begin__ = 52;
            lp_accum__.add(normal_log<propto__>(bgamma, 0, sqrt(C)));
            current_statement_begin__ = 53;
            lp_accum__.add(normal_log<propto__>(nphi, 0, 1));
            current_statement_begin__ = 54;
            lp_accum__.add(uniform_log<propto__>(uvs, 0, 1));
            current_statement_begin__ = 55;
            lp_accum__.add(normal_log<propto__>(nvs, 0, 1));
            current_statement_begin__ = 58;
            if (as_bool(logical_eq(0,D))) {

                current_statement_begin__ = 60;
                lp_accum__.add(-(log(omega)));
            } else {

                current_statement_begin__ = 63;
                lp_accum__.add(normal_log<propto__>(omega, 0, sqrt(D)));
            }
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(Y, mu, vs));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("omega");
        names__.push_back("b0");
        names__.push_back("bgamma");
        names__.push_back("uvs");
        names__.push_back("nvs");
        names__.push_back("nphi");
        names__.push_back("vs");
        names__.push_back("mu");
        names__.push_back("phi");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(SIZE);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_srs_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double omega = in__.scalar_lb_constrain(0);
        double b0 = in__.scalar_constrain();
        vector_d bgamma = in__.vector_constrain(NX);
        vector_d uvs = in__.vector_lub_constrain(0,1,SIZE);
        vector_d nvs = in__.vector_constrain(SIZE);
        vector_d nphi = in__.vector_constrain(SIZE);
        vars__.push_back(omega);
        vars__.push_back(b0);
        for (int k_0__ = 0; k_0__ < NX; ++k_0__) {
            vars__.push_back(bgamma[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(uvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nvs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(nphi[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        validate_non_negative_index("vs", "SIZE", SIZE);
        vector_d vs(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) vs;  // dummy to suppress unused var warning

        stan::math::initialize(vs, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(vs,DUMMY_VAR__);
        validate_non_negative_index("mu", "SIZE", SIZE);
        vector_d mu(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) mu;  // dummy to suppress unused var warning

        stan::math::initialize(mu, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(mu,DUMMY_VAR__);
        validate_non_negative_index("phi", "SIZE", SIZE);
        vector_d phi(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) phi;  // dummy to suppress unused var warning

        stan::math::initialize(phi, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(phi,DUMMY_VAR__);


        try {
            current_statement_begin__ = 39;
            if (as_bool(logical_eq(0,PRIORSIG))) {

                current_statement_begin__ = 40;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(subtract(multiply(uvs,2),1),DELTA))));
            } else {

                current_statement_begin__ = 42;
                stan::math::assign(vs, exp(add(log(SIGY),multiply(nvs,sqrt(DELTA)))));
            }
            current_statement_begin__ = 45;
            stan::math::assign(phi, multiply(nphi,omega));
            current_statement_begin__ = 46;
            stan::math::assign(mu, add(add(b0,multiply(X,bgamma)),phi));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        check_greater_or_equal(function__,"vs",vs,0);

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(vs[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(mu[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }

        if (!include_gqs__) return;
        // declare and define generated quantities
        validate_non_negative_index("log_lik", "SIZE", SIZE);
        vector_d log_lik(static_cast<Eigen::VectorXd::Index>(SIZE));
        (void) log_lik;  // dummy to suppress unused var warning

        stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(log_lik,DUMMY_VAR__);


        try {
            current_statement_begin__ = 71;
            for (int i = 1; i <= SIZE; ++i) {

                current_statement_begin__ = 72;
                stan::math::assign(get_base1_lhs(log_lik,i,"log_lik",1), normal_log(get_base1(Y,i,"Y",1),get_base1(mu,i,"mu",1),get_base1(vs,i,"vs",1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
        for (int k_0__ = 0; k_0__ < SIZE; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
        }

    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_srs";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nphi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "omega";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "b0";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= NX; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bgamma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "uvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nvs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nphi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "vs" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= SIZE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




#endif
