% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_present.R
\name{bzComp}
\alias{bzComp}
\alias{bzSummaryComp}
\alias{bzPlotComp}
\alias{bzForestComp}
\title{Comparison of posterior treatment effects}
\usage{
bzSummaryComp(stan.rst, sel.grps = NULL, cut = 0, digits = 3)

bzPlotComp(stan.rst, sel.grps = NULL, ...)

bzForestComp(stan.rst, sel.grps = NULL, ..., quants = c(0.025, 0.975))
}
\arguments{
\item{stan.rst}{a class \code{beanz.stan} object generated by
\code{\link{bzCallStan}}}

\item{sel.grps}{an array of subgroup numbers to be included in the summary results}

\item{cut}{cut point to compute the probabiliby that the posterior subgroup
treatment effects is below}

\item{digits}{number of digits in the summary result table}

\item{...}{options for \code{plot} function}

\item{quants}{lower and upper quantiles of the credible intervals in the
forest plot}
}
\value{
\code{bzSummaryComp} generates a data frame with summary statistics
    of the difference of treatment effects between the selected subgroups.
    \code{bzPlotComp} generates the density plot of the difference in the
    posterior treatment effects between subgroups. \code{bzForestComp}
    generates the forest plot of the difference in the posterior treatment
    effects between subgroups.
}
\description{
Present the difference in the posterior treatment effects
between subgroups
}
\examples{

var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
var.estvar <- c("Estimate", "Variance");

subgrp.effect <- bzGetSubgrpRaw(solvd.sub,
                             var.resp   = var.resp,
                             var.trt    = var.trt,
                             var.cov    = var.cov,
                             var.censor = var.censor,
                             resptype   = resptype);

rst.sr     <- bzCallStan("sr", dat.sub=subgrp.effect,
                         var.estvar=var.estvar, var.cov = var.cov,
                         par.pri=c(B=1000, C=1000),
                         chains=4, iter=500,
                         warmup=100, thin=2, seed=1000);

sel.grps <- c(1,4,5);
tbl.sub <- bzSummaryComp(rst.sr, sel.grps=sel.grps);
bzPlot(rst.sr, sel.grps = sel.grps);
bzForest(rst.sr, sel.grps = sel.grps);


}
\seealso{
\code{\link{bzCallStan}}
}
