% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connections.R
\name{Connections}
\alias{Connections}
\title{Class to manage the connections with Twitter and YouTube}
\description{
The tasks of the functions that the \code{\link{Connections}} class has are to
establish the connections and control the number of requests that have been made
with the APIs of Twitter and YouTube.
}
\section{Details}{

The way to indicate the keys of YouTube and Twitter has to be
through fields of \emph{\link{bdpar.Options}} variable:

\strong{[twitter]}

- \code{bdpar.Options$set("twitter.consumer.key", <<consumer_key>>)}

- \code{bdpar.Options$set("twitter.consumer.secret", <<consumer_secret>>)}

- \code{bdpar.Options$set("twitter.access.token", <<access_token>>)}

- \code{bdpar.Options$set("twitter.access.token.secret", <<access_token_secret>>)}

\strong{[youtube]}

- \code{bdpar.Options$set("youtube.app.id", <<app_id>>)}

- \code{bdpar.Options$set("youtube.app.password", <<app_password>>)}
}

\section{Note}{

Fields of unused connections will be automatically ignored by the platform.
}

\seealso{
\code{\link{bdpar.Options}}, \code{\link{ExtractorTwtid}},
         \code{\link{ExtractorYtbid}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Connections$new()}}
\item \href{#method-getTwitterToken}{\code{Connections$getTwitterToken()}}
\item \href{#method-startConnectionWithTwitter}{\code{Connections$startConnectionWithTwitter()}}
\item \href{#method-checkRequestToTwitter}{\code{Connections$checkRequestToTwitter()}}
\item \href{#method-startConnectionWithYoutube}{\code{Connections$startConnectionWithYoutube()}}
\item \href{#method-addNumRequestToYoutube}{\code{Connections$addNumRequestToYoutube()}}
\item \href{#method-checkRequestToYoutube}{\code{Connections$checkRequestToYoutube()}}
\item \href{#method-getNumRequestMaxToYoutube}{\code{Connections$getNumRequestMaxToYoutube()}}
\item \href{#method-clone}{\code{Connections$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{Connections}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getTwitterToken"></a>}}
\if{latex}{\out{\hypertarget{method-getTwitterToken}{}}}
\subsection{Method \code{getTwitterToken()}}{
Gets the Twitter token ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$getTwitterToken()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of \code{twitterToken}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-startConnectionWithTwitter"></a>}}
\if{latex}{\out{\hypertarget{method-startConnectionWithTwitter}{}}}
\subsection{Method \code{startConnectionWithTwitter()}}{
Responsible of establishing the connection to Twitter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$startConnectionWithTwitter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-checkRequestToTwitter"></a>}}
\if{latex}{\out{\hypertarget{method-checkRequestToTwitter}{}}}
\subsection{Method \code{checkRequestToTwitter()}}{
Function in charge of handling the connection with Twitter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$checkRequestToTwitter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-startConnectionWithYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-startConnectionWithYoutube}{}}}
\subsection{Method \code{startConnectionWithYoutube()}}{
Function able to establish the connection with YouTube.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$startConnectionWithYoutube()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addNumRequestToYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-addNumRequestToYoutube}{}}}
\subsection{Method \code{addNumRequestToYoutube()}}{
Function that increases in one the number of request to YouTube.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$addNumRequestToYoutube()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-checkRequestToYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-checkRequestToYoutube}{}}}
\subsection{Method \code{checkRequestToYoutube()}}{
Handles the connection with YouTube.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$checkRequestToYoutube()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNumRequestMaxToYoutube"></a>}}
\if{latex}{\out{\hypertarget{method-getNumRequestMaxToYoutube}{}}}
\subsection{Method \code{getNumRequestMaxToYoutube()}}{
Gets the number of maximum requests allowed by YouTube API.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$getNumRequestMaxToYoutube()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of number maximum of request to YouTube.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Connections$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
