% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynamicPipeline.R
\docType{class}
\name{DynamicPipeline}
\alias{DynamicPipeline}
\title{Class implementing a dynamic pipelining proccess.}
\usage{
DynamicPipeline
}
\description{
This \code{\link{DynamicPipeline}} class inherits from the
\code{\link{GenericPipeline}} class. Includes the \strong{execute} method which
provides a dynamic pipelining implementation.
}
\section{Constructor}{

\code{DynamicPipeline$new(pipeline = NULL)}
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipeline}} and implements the
\code{execute} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{add:}}{
adds a pipe or a pipe list to the pipeline
\itemize{
\item{\emph{Usage:}}{
\code{add(pipe, pos)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{pipe:}}{
(\emph{GenericPipe}) pipe objects or a list of pipes to add
}
\item{\strong{pos:}}{
(\emph{numeric}) the value of the pos to add. If it is NULL, pipe is appended to the pipeline
}
}
}
}
}

\item{\bold{removeByPos:}}{
removes pipes by the position on the pipeline
\itemize{
\item{\emph{Usage:}}{
\code{removeByPos(pos)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{pos:}}{
(\emph{numeric}) the pipe positions to remove.
}
}
}
}
}

\item{\bold{removeByPipe:}}{
removes pipes by its name on the pipeline
\itemize{
\item{\emph{Usage:}}{
\code{removeByPipe(pipe.name)}
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{pipe.name:}}{
(\emph{character}) the pipe name to remove.
}
}
}
}
}

\item{\bold{removeAll:}}{
removes all pipes included on pipeline
\itemize{
\item{\emph{Usage:}}{
\code{removeAll()}
}
}
}

\item{\bold{execute:}}{
function where is implemented the flow of the pipes.
\itemize{
\item{\emph{Usage:}}{
\code{execute(instance)}
}
\item{\emph{Value:}}{
the preprocessed \code{\link{Instance}}.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) the \code{\link{Instance}} that is going to be processed.
}
}
}
}
}

\item{\bold{get:}}{
gets a list with containinig the set of pipes of the pipeline,
\itemize{
\item{\emph{Usage:}}{
\code{get()}
}
\item{\emph{Value:}}{
the set of pipes containing the pipeline.
}
}
}
}
}

\seealso{
\code{\link{Instance}}, \code{\link{DefaultPipeline}},
         \code{\link{GenericPipeline}}, \code{\link{GenericPipe}},
         \code{\link{\%>|\%}}
}
