% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bdlim4.R
\name{summary.bdlim4}
\alias{summary.bdlim4}
\title{Summary for bdlim4}
\usage{
\method{summary}{bdlim4}(object, model = NULL, ...)
}
\arguments{
\item{object}{An object of class bdlim4.}

\item{model}{Pattern of heterogeneity to be printed. If not specified (default) the best fitting model will be used. Options are "n", "b", "w" and "bw" where b indicates the effect sizes are subgroup specific and w indicates the weight functions are subgroups specific.}

\item{...}{Other arguments}
}
\value{
An object of class summary.bdlim2.
}
\description{
Summary for bdlim4
}
\examples{
\donttest{

# run BDLIM with modification by ChildSex
fit_sex <- bdlim4(
  y = sbd_bdlim$bwgaz,
  exposure = sbd_bdlim[,paste0("pm25_",1:37)],
  covars = sbd_bdlim[,c("MomPriorBMI","MomAge","race","Hispanic",
                                      "EstMonthConcept","EstYearConcept")],
  group = as.factor(sbd_bdlim$ChildSex),
  df = 5,
  nits = 5000,
  parallel = FALSE
)

#summarize results
summary(fit_sex)

# obtain estimates of the distributed lag function
# these are note displayed when printed but available for use
sfit_sex <- summary(fit_sex)
head(sfit_sex$dlfun)

# can summarize with a specific model
sfit_hisp_n <- summary(fit_sex, model="n") # no modification
sfit_hisp_b <- summary(fit_sex, model="b") # subgroup-specific effects (beta)
sfit_hisp_w <- summary(fit_sex, model="w") # subgroup-specific weight function
sfit_hisp_bw <- summary(fit_sex, model="bw") # both subgroup-specific

}
}
