% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcp.R
\name{bcpImport}
\alias{bcpImport}
\title{Import data to SQL Server}
\usage{
bcpImport(
  x,
  server,
  database,
  table,
  driver = "SQL Server",
  maxerrors = 10,
  batchsize = 1000,
  packetsize = 4096,
  regional = FALSE,
  trustedconnection = TRUE,
  username,
  password,
  fieldterminator = "\\t",
  rowterminator = ifelse(.Platform$OS.type == "windows", "\\r\\n", "\\n"),
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{x}{dataframe object or path to file}

\item{server}{the instance of SQL Server to which to connect}

\item{database}{Specifies the database to connect to}

\item{table}{name of the source table when exporting from  SQL Server}

\item{driver}{name of driver for ODBC connection}

\item{maxerrors}{maximum number of errors allowed}

\item{batchsize}{number of rows to write at a time; 10,000 to 50,000 is a
starting recommendation}

\item{packetsize}{size of packets to be sent}

\item{regional}{Specifies that currency, date, and time data is bulk copied into SQL Server
using the regional format defined for the locale setting of the client
computer}

\item{trustedconnection}{use integrated security, username and password are not required}

\item{username}{login ID}

\item{password}{password for login ID}

\item{fieldterminator}{character separator for columns}

\item{rowterminator}{character separator for rows--new lines}

\item{overwrite}{Whether to overwrite the table if it exists}

\item{...}{arguments to pass to \link[base]{system2}}
}
\value{
No return value. Operations from bcp are printed to console; see
\code{...} to redirect output
}
\description{
A wrapper for a system call to the bcp utility which bulk inserts to SQL Server.
}
\details{
If x is a dataframe object, \code{data.table::fwrite} is used to write the
in memory object to disk in a temporary file that is deleted when the
function exits. The \code{fieldterminator} and \code{rowterminator} are
ignored in this case.

If \code{overwrite} is \code{TRUE}, any existing table of the same name
will be deleted and the schema is inferred from \code{DBI::dbCreateTable}. To
use a customized schema, create the schema before calling the function and
use \code{overwrite=FALSE}.
}
\examples{
\dontrun{
set.seed(33)
x <- data.frame(
  w = rpois(10, 10),
  x = rnorm(10),
  y = sample(LETTERS, 10),
  z = Sys.time()
)
bcpImport(x,
          server = server,
          database = database,
          table = 'mytable')
}
}
