% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_strat_estimation.R
\name{estimate_total}
\alias{estimate_total}
\title{Post-stratification analysis}
\usage{
estimate_total(est_df, pop_df, strata)
}
\arguments{
\item{est_df}{A \code{\link[=data.frame]{data.frame()}} of stratified indicator estimates to get
overall estimates of. \code{est_df} should have a variable named \code{est} for
the values of the indicator estimate, a variable named \code{strata} for
information on the stratification or grouping of the estimates, and a
variable named \code{se} for the standard errors for the values of the
indicator estimate. This is usually produced via a call to
\code{\link[=boot_bw_estimate]{boot_bw_estimate()}}.}

\item{pop_df}{A \code{\link[=data.frame]{data.frame()}} with at least two variables: \code{strata} for the
stratification/grouping information that matches \code{strata} in \code{est_df} and
\code{pop} for information on population for the given \code{strata}.}

\item{strata}{A character value of the variable name in \code{est_df} that
corresponds to the \code{strata} values to match with values in \code{pop_df}}
}
\value{
A vector of values for the overall estimate, overall 95\% lower
confidence limit, and overall 95\% upper confidence limit for each of the
\code{strata} in \code{est_df}.
}
\description{
Post-stratification analysis
}
\examples{
est_df <- boot_bw(
  x = indicatorsHH, w = villageData, statistic = bootClassic, 
  params = "anc1", strata = "region", replicates = 9, parallel = TRUE
) |>
  boot_bw_estimate()

## Add population ----
pop_df <- somalia_population |>
  subset(select = c(region, total))

names(pop_df) <- c("strata", "pop")

estimate_total(est_df, pop_df, strata = "region")

}
