% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-indices.R
\name{plot_indices}
\alias{plot_indices}
\title{Generate plots of index trajectories by stratum}
\usage{
plot_indices(indices_list = NULL, ci_width = 0.95, min_year = NULL,
  max_year = NULL, species = "", title_size = 20,
  axis_title_size = 18, axis_text_size = 16,
  add_observed_means = FALSE, add_number_routes = FALSE)
}
\arguments{
\item{indices_list}{List of indices of annual abundance and other results produced by
\code{generate_strata_indices}}

\item{ci_width}{quantile to define the width of the plotted credible interval. Defaults to 0.95, lower = 0.025 and upper = 0.975}

\item{min_year}{Minimum year to plot}

\item{max_year}{Maximum year to plot}

\item{species}{Species name to be added onto the plot}

\item{title_size}{Specify font size of plot title. Defaults to 20}

\item{axis_title_size}{Specify font size of axis titles. Defaults to 18}

\item{axis_text_size}{Specify font size of axis text. Defaults to 16}

\item{add_observed_means}{Should the plot include points indicated the observed mean counts. Defaults to FALSE. Note: scale of observed means and annual indices may not match due to imbalanced sampling among routes}

\item{add_number_routes}{Should the plot be superimposed over a dotplot showing the number of BBS routes included in each year. This is useful as a visual check on the relative data-density through time because in most cases the number of observations increases over time}
}
\value{
List of ggplot objects, each entry being a plot
  of a stratum indices
}
\description{
Generates the indices plot for each stratum modelled.
}
\examples{

# Toy example with Pacific Wren sample data
# First, stratify the sample data

strat_data <- stratify(by = "bbs_cws", sample_data = TRUE)

# Prepare the stratified data for use in a JAGS model.
jags_data <- prepare_jags_data(strat_data = strat_data,
                               species_to_run = "Pacific Wren",
                               model = "firstdiff",
                               min_year = 2009,
                               max_year = 2018)

# Now run a JAGS model.
jags_mod <- run_model(jags_data = jags_data,
                      n_adapt = 0,
                      n_burnin = 0,
                      n_iter = 10,
                      n_thin = 1)

# Generate only national, continental, and stratum indices
indices <- generate_indices(jags_mod = jags_mod,
                            jags_data = jags_data,
                            regions = c("national",
                                        "continental",
                                        "stratum"))

# Now, plot_indices() will generate a list of plots for all regions
plot_list <- plot_indices(indices_list = indices,
                          species = "Pacific Wren")

#Suppose we wanted to access the continental plot. We could do so with
cont_plot <- plot_list$continental

# You can specify to only plot a subset of years using min_year and max_year
# Plots indices from 2015 onward
plot_list_2015_on <- plot_indices(indices_list = indices,
                                  min_year = 2015,
                                  species = "Pacific Wren")

#Plot up indices up to the year 2017
plot_list_max_2017 <- plot_indices(indices_list = indices,
                                   max_year = 2017,
                                   species = "Pacific Wren")

#Plot indices between 2011 and 2016
plot_list_2011_2015 <- plot_indices(indices_list = indices,
                                    min_year = 2011,
                                    max_year = 2016,
                                    species = "Pacific Wren")

}
