% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{dPosteriorPredictive.DP}
\alias{dPosteriorPredictive.DP}
\title{Posterior predictive density function of a Dirichlet Process object}
\usage{
\method{dPosteriorPredictive}{DP}(obj, x, z, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "DP" object.}

\item{x}{Random samples of the "BasicBayesian" object.}

\item{z}{integer, the partition label of the parameter space where the observation x is drawn from.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the posterior predictive density.
}
\description{
Generate the the density value of the posterior predictive distribution of the following structure:
     \deqn{pi|alpha ~ DP(alpha,U)}
     \deqn{z|pi ~ Categorical(pi)}
     \deqn{theta_z|psi ~ H0(psi)}
     \deqn{x|theta_z,z ~ F(theta_z)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process. The choice of F() and H0() can be described by an arbitrary "BasicBayesian" object such as "GaussianGaussian","GaussianInvWishart","GaussianNIW", "GaussianNIG", "CatDirichlet", and "CatDP". See \code{?BasicBayesian} for definition of "BasicBayesian" objects, and see for example \code{?GaussianGaussian} for specific "BasicBayesian" instances. As a summary, An "DP" object is simply a combination of a "CatDP" object (see \code{?CatDP}) and an object of any "BasicBayesian" type.\cr
The model structure and prior parameters are stored in a "DP" object. \cr
Posterior predictive density = p(x,z|alpha,psi).
}
\examples{
x <- rnorm(4)
z <- sample(1L:10L,size = 4,replace = TRUE)
obj <- DP()
ss <- sufficientStatistics(obj = obj,x=x,foreach = TRUE)
for(i in 1L:length(x)) posterior(obj = obj,ss=ss[[i]],z=z[i])
xnew <- rnorm(10)
znew <- sample(1L:10L,size = 10,replace = TRUE)
dPosteriorPredictive(obj = obj,x=xnew,z=znew)
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{DP}}, \code{\link{dPosteriorPredictive.DP}}, \code{\link{marginalLikelihood.DP}}
}
