% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posterior.HDP}
\alias{posterior.HDP}
\title{Update a "HDP" object with sample sufficient statistics}
\usage{
\method{posterior}{HDP}(obj, ss, ss1, ss2, j, w = NULL, ...)
}
\arguments{
\item{obj}{A "HDP" object.}

\item{ss}{Sufficient statistics of x of the "BasicBayesian" object, must be a list of sufficient statistics for each of the observations. Use sufficientStatistics(...,foreach=TRUE) to generate ss.}

\item{ss1}{Sufficient statistics of k. In HDP case the sufficient statistic of sample k is k itself(if k is a integer vector with all positive values).}

\item{ss2}{Sufficient statistics of z. In HDP case the sufficient statistic of sample z is z itself(if z is a integer vector with all positive values).}

\item{j}{integer, group label.}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated based on "ss", "ss1" and "ss2".
}
\description{
For the model structure: \cr
     G_j|gamma ~ DP(gamma,U), j = 1:J \cr
     pi_j|G_j,alpha ~ DP(alpha,G_j) \cr
     z|pi_j ~ Categorical(pi_j) \cr
     k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G \cr
     theta_k|psi ~ H0(psi) \cr
     x|theta_k,k ~ F(theta_k) \cr
where DP(gamma,U) is a Dirichlet Process on positive integers, gamma is the "concentration parameter", U is the "base measure" of this Dirichlet process, U is an uniform distribution on all positive integers.  DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. The choice of F() and H0() can be arbitrary, they are distributions of x and theta_k correspondingly. \cr
In the case of HDP, z and k can only be positive integers. \cr
This function will update the prior knowledge by adding the information of newly observed samples x, z and k. The model structure and prior parameters are stored in a "HDP" object, the prior parameters in this object will be updated after running this function.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{HDP}},\code{\link{posteriorDiscard.HDP}},\code{\link{sufficientStatistics.HDP}}
}
